/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import java.util.Objects;

public class MarkdownDocumentationNode
extends DocumentationNode {
    public MarkdownDocumentationNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<Node> documentationLines() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(0));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"documentationLines"};
    }

    public MarkdownDocumentationNode modify(NodeList<Node> documentationLines) {
        if (this.checkForReferenceEquality(documentationLines.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createMarkdownDocumentationNode(documentationLines);
    }

    public MarkdownDocumentationNodeModifier modify() {
        return new MarkdownDocumentationNodeModifier(this);
    }

    public static class MarkdownDocumentationNodeModifier {
        private final MarkdownDocumentationNode oldNode;
        private NodeList<Node> documentationLines;

        public MarkdownDocumentationNodeModifier(MarkdownDocumentationNode oldNode) {
            this.oldNode = oldNode;
            this.documentationLines = oldNode.documentationLines();
        }

        public MarkdownDocumentationNodeModifier withDocumentationLines(NodeList<Node> documentationLines) {
            Objects.requireNonNull(documentationLines, "documentationLines must not be null");
            this.documentationLines = documentationLines;
            return this;
        }

        public MarkdownDocumentationNode apply() {
            return this.oldNode.modify(this.documentationLines);
        }
    }
}

