/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class RecordRestDescriptorNode
extends NonTerminalNode {
    public RecordRestDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node typeName() {
        return this.childInBucket(0);
    }

    public Token ellipsisToken() {
        return (Token)this.childInBucket(1);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"typeName", "ellipsisToken", "semicolonToken"};
    }

    public RecordRestDescriptorNode modify(Node typeName, Token ellipsisToken, Token semicolonToken) {
        if (this.checkForReferenceEquality(typeName, ellipsisToken, semicolonToken)) {
            return this;
        }
        return NodeFactory.createRecordRestDescriptorNode(typeName, ellipsisToken, semicolonToken);
    }

    public RecordRestDescriptorNodeModifier modify() {
        return new RecordRestDescriptorNodeModifier(this);
    }

    public static class RecordRestDescriptorNodeModifier {
        private final RecordRestDescriptorNode oldNode;
        private Node typeName;
        private Token ellipsisToken;
        private Token semicolonToken;

        public RecordRestDescriptorNodeModifier(RecordRestDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.typeName = oldNode.typeName();
            this.ellipsisToken = oldNode.ellipsisToken();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public RecordRestDescriptorNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public RecordRestDescriptorNodeModifier withEllipsisToken(Token ellipsisToken) {
            Objects.requireNonNull(ellipsisToken, "ellipsisToken must not be null");
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public RecordRestDescriptorNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public RecordRestDescriptorNode apply() {
            return this.oldNode.modify(this.typeName, this.ellipsisToken, this.semicolonToken);
        }
    }
}

