/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class SpecificFieldNode
extends MappingFieldNode {
    public SpecificFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> readonlyKeyword() {
        return this.optionalChildInBucket(0);
    }

    public Node fieldName() {
        return this.childInBucket(1);
    }

    public Optional<Token> colon() {
        return this.optionalChildInBucket(2);
    }

    public Optional<ExpressionNode> valueExpr() {
        return this.optionalChildInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"readonlyKeyword", "fieldName", "colon", "valueExpr"};
    }

    public SpecificFieldNode modify(Token readonlyKeyword, Node fieldName, Token colon, ExpressionNode valueExpr) {
        if (this.checkForReferenceEquality(readonlyKeyword, fieldName, colon, valueExpr)) {
            return this;
        }
        return NodeFactory.createSpecificFieldNode(readonlyKeyword, fieldName, colon, valueExpr);
    }

    public SpecificFieldNodeModifier modify() {
        return new SpecificFieldNodeModifier(this);
    }

    public static class SpecificFieldNodeModifier {
        private final SpecificFieldNode oldNode;
        private Token readonlyKeyword;
        private Node fieldName;
        private Token colon;
        private ExpressionNode valueExpr;

        public SpecificFieldNodeModifier(SpecificFieldNode oldNode) {
            this.oldNode = oldNode;
            this.readonlyKeyword = oldNode.readonlyKeyword().orElse(null);
            this.fieldName = oldNode.fieldName();
            this.colon = oldNode.colon().orElse(null);
            this.valueExpr = oldNode.valueExpr().orElse(null);
        }

        public SpecificFieldNodeModifier withReadonlyKeyword(Token readonlyKeyword) {
            this.readonlyKeyword = readonlyKeyword;
            return this;
        }

        public SpecificFieldNodeModifier withFieldName(Node fieldName) {
            Objects.requireNonNull(fieldName, "fieldName must not be null");
            this.fieldName = fieldName;
            return this;
        }

        public SpecificFieldNodeModifier withColon(Token colon) {
            this.colon = colon;
            return this;
        }

        public SpecificFieldNodeModifier withValueExpr(ExpressionNode valueExpr) {
            this.valueExpr = valueExpr;
            return this;
        }

        public SpecificFieldNode apply() {
            return this.oldNode.modify(this.readonlyKeyword, this.fieldName, this.colon, this.valueExpr);
        }
    }
}

