/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class TransactionalExpressionNode
extends ExpressionNode {
    public TransactionalExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token transactionalKeyword() {
        return (Token)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"transactionalKeyword"};
    }

    public TransactionalExpressionNode modify(Token transactionalKeyword) {
        if (this.checkForReferenceEquality(transactionalKeyword)) {
            return this;
        }
        return NodeFactory.createTransactionalExpressionNode(transactionalKeyword);
    }

    public TransactionalExpressionNodeModifier modify() {
        return new TransactionalExpressionNodeModifier(this);
    }

    public static class TransactionalExpressionNodeModifier {
        private final TransactionalExpressionNode oldNode;
        private Token transactionalKeyword;

        public TransactionalExpressionNodeModifier(TransactionalExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.transactionalKeyword = oldNode.transactionalKeyword();
        }

        public TransactionalExpressionNodeModifier withTransactionalKeyword(Token transactionalKeyword) {
            Objects.requireNonNull(transactionalKeyword, "transactionalKeyword must not be null");
            this.transactionalKeyword = transactionalKeyword;
            return this;
        }

        public TransactionalExpressionNode apply() {
            return this.oldNode.modify(this.transactionalKeyword);
        }
    }
}

