/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class UnionTypeDescriptorNode
extends TypeDescriptorNode {
    public UnionTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public TypeDescriptorNode leftTypeDesc() {
        return (TypeDescriptorNode)this.childInBucket(0);
    }

    public Token pipeToken() {
        return (Token)this.childInBucket(1);
    }

    public TypeDescriptorNode rightTypeDesc() {
        return (TypeDescriptorNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"leftTypeDesc", "pipeToken", "rightTypeDesc"};
    }

    public UnionTypeDescriptorNode modify(TypeDescriptorNode leftTypeDesc, Token pipeToken, TypeDescriptorNode rightTypeDesc) {
        if (this.checkForReferenceEquality(leftTypeDesc, pipeToken, rightTypeDesc)) {
            return this;
        }
        return NodeFactory.createUnionTypeDescriptorNode(leftTypeDesc, pipeToken, rightTypeDesc);
    }

    public UnionTypeDescriptorNodeModifier modify() {
        return new UnionTypeDescriptorNodeModifier(this);
    }

    public static class UnionTypeDescriptorNodeModifier {
        private final UnionTypeDescriptorNode oldNode;
        private TypeDescriptorNode leftTypeDesc;
        private Token pipeToken;
        private TypeDescriptorNode rightTypeDesc;

        public UnionTypeDescriptorNodeModifier(UnionTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.leftTypeDesc = oldNode.leftTypeDesc();
            this.pipeToken = oldNode.pipeToken();
            this.rightTypeDesc = oldNode.rightTypeDesc();
        }

        public UnionTypeDescriptorNodeModifier withLeftTypeDesc(TypeDescriptorNode leftTypeDesc) {
            Objects.requireNonNull(leftTypeDesc, "leftTypeDesc must not be null");
            this.leftTypeDesc = leftTypeDesc;
            return this;
        }

        public UnionTypeDescriptorNodeModifier withPipeToken(Token pipeToken) {
            Objects.requireNonNull(pipeToken, "pipeToken must not be null");
            this.pipeToken = pipeToken;
            return this;
        }

        public UnionTypeDescriptorNodeModifier withRightTypeDesc(TypeDescriptorNode rightTypeDesc) {
            Objects.requireNonNull(rightTypeDesc, "rightTypeDesc must not be null");
            this.rightTypeDesc = rightTypeDesc;
            return this;
        }

        public UnionTypeDescriptorNode apply() {
            return this.oldNode.modify(this.leftTypeDesc, this.pipeToken, this.rightTypeDesc);
        }
    }
}

