/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IntermediateClauseNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class WhereClauseNode
extends IntermediateClauseNode {
    public WhereClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token whereKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"whereKeyword", "expression"};
    }

    public WhereClauseNode modify(Token whereKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(whereKeyword, expression)) {
            return this;
        }
        return NodeFactory.createWhereClauseNode(whereKeyword, expression);
    }

    public WhereClauseNodeModifier modify() {
        return new WhereClauseNodeModifier(this);
    }

    public static class WhereClauseNodeModifier {
        private final WhereClauseNode oldNode;
        private Token whereKeyword;
        private ExpressionNode expression;

        public WhereClauseNodeModifier(WhereClauseNode oldNode) {
            this.oldNode = oldNode;
            this.whereKeyword = oldNode.whereKeyword();
            this.expression = oldNode.expression();
        }

        public WhereClauseNodeModifier withWhereKeyword(Token whereKeyword) {
            Objects.requireNonNull(whereKeyword, "whereKeyword must not be null");
            this.whereKeyword = whereKeyword;
            return this;
        }

        public WhereClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public WhereClauseNode apply() {
            return this.oldNode.modify(this.whereKeyword, this.expression);
        }
    }
}

