/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.XMLNamePatternChainingNode;
import io.ballerina.compiler.syntax.tree.XMLNavigateExpressionNode;
import java.util.Objects;

public class XMLFilterExpressionNode
extends XMLNavigateExpressionNode {
    public XMLFilterExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public XMLNamePatternChainingNode xmlPatternChain() {
        return (XMLNamePatternChainingNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "xmlPatternChain"};
    }

    public XMLFilterExpressionNode modify(ExpressionNode expression, XMLNamePatternChainingNode xmlPatternChain) {
        if (this.checkForReferenceEquality(expression, xmlPatternChain)) {
            return this;
        }
        return NodeFactory.createXMLFilterExpressionNode(expression, xmlPatternChain);
    }

    public XMLFilterExpressionNodeModifier modify() {
        return new XMLFilterExpressionNodeModifier(this);
    }

    public static class XMLFilterExpressionNodeModifier {
        private final XMLFilterExpressionNode oldNode;
        private ExpressionNode expression;
        private XMLNamePatternChainingNode xmlPatternChain;

        public XMLFilterExpressionNodeModifier(XMLFilterExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.xmlPatternChain = oldNode.xmlPatternChain();
        }

        public XMLFilterExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public XMLFilterExpressionNodeModifier withXmlPatternChain(XMLNamePatternChainingNode xmlPatternChain) {
            Objects.requireNonNull(xmlPatternChain, "xmlPatternChain must not be null");
            this.xmlPatternChain = xmlPatternChain;
            return this;
        }

        public XMLFilterExpressionNode apply() {
            return this.oldNode.modify(this.expression, this.xmlPatternChain);
        }
    }
}

