/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import io.ballerina.compiler.syntax.tree.XMLSimpleNameNode;
import java.util.Objects;

public class XMLQualifiedNameNode
extends XMLNameNode {
    public XMLQualifiedNameNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public XMLSimpleNameNode prefix() {
        return (XMLSimpleNameNode)this.childInBucket(0);
    }

    public Token colon() {
        return (Token)this.childInBucket(1);
    }

    public XMLSimpleNameNode name() {
        return (XMLSimpleNameNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"prefix", "colon", "name"};
    }

    public XMLQualifiedNameNode modify(XMLSimpleNameNode prefix, Token colon, XMLSimpleNameNode name) {
        if (this.checkForReferenceEquality(prefix, colon, name)) {
            return this;
        }
        return NodeFactory.createXMLQualifiedNameNode(prefix, colon, name);
    }

    public XMLQualifiedNameNodeModifier modify() {
        return new XMLQualifiedNameNodeModifier(this);
    }

    public static class XMLQualifiedNameNodeModifier {
        private final XMLQualifiedNameNode oldNode;
        private XMLSimpleNameNode prefix;
        private Token colon;
        private XMLSimpleNameNode name;

        public XMLQualifiedNameNodeModifier(XMLQualifiedNameNode oldNode) {
            this.oldNode = oldNode;
            this.prefix = oldNode.prefix();
            this.colon = oldNode.colon();
            this.name = oldNode.name();
        }

        public XMLQualifiedNameNodeModifier withPrefix(XMLSimpleNameNode prefix) {
            Objects.requireNonNull(prefix, "prefix must not be null");
            this.prefix = prefix;
            return this;
        }

        public XMLQualifiedNameNodeModifier withColon(Token colon) {
            Objects.requireNonNull(colon, "colon must not be null");
            this.colon = colon;
            return this;
        }

        public XMLQualifiedNameNodeModifier withName(XMLSimpleNameNode name) {
            Objects.requireNonNull(name, "name must not be null");
            this.name = name;
            return this;
        }

        public XMLQualifiedNameNode apply() {
            return this.oldNode.modify(this.prefix, this.colon, this.name);
        }
    }
}

