/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.oauth2;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BString;

public class ModuleUtils {
    private static Module oauth2Module;
    private static double oauth2ConnectionTimeout;
    private static double oauth2RequestTimeout;

    private ModuleUtils() {
    }

    public static void setModule(Environment env) {
        oauth2Module = env.getCurrentModule();
    }

    public static Module getModule() {
        return oauth2Module;
    }

    public static Object setOauth2ConnectionTimeout(BDecimal timeout) {
        oauth2ConnectionTimeout = timeout.floatValue();
        if (oauth2ConnectionTimeout <= 0.0) {
            String errMsg = "OAuth2 connection timeout must be greater than zero";
            return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)errMsg), null, null);
        }
        return null;
    }

    public static double getOauth2ConnectionTimeout() {
        return oauth2ConnectionTimeout;
    }

    public static Object setOauth2RequestTimeout(BDecimal timeout) {
        oauth2RequestTimeout = timeout.floatValue();
        if (oauth2RequestTimeout <= 0.0) {
            String errMsg = "OAuth2 request timeout must be greater than zero";
            return ErrorCreator.createError((Module)ModuleUtils.getModule(), (String)"Error", (BString)StringUtils.fromString((String)errMsg), null, null);
        }
        return null;
    }

    public static double getOauth2RequestTimeout() {
        return oauth2RequestTimeout;
    }

    static {
        oauth2ConnectionTimeout = 15.0;
        oauth2RequestTimeout = 30.0;
    }
}

