/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.parameterprocessor;

import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.StructureType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.stdlib.io.channels.base.Channel;
import io.ballerina.stdlib.io.channels.base.CharacterChannel;
import io.ballerina.stdlib.io.readers.CharacterChannelReader;
import io.ballerina.stdlib.io.utils.IOUtils;
import io.ballerina.stdlib.sql.Constants;
import io.ballerina.stdlib.sql.exception.ConversionError;
import io.ballerina.stdlib.sql.exception.DataError;
import io.ballerina.stdlib.sql.exception.TypeMismatchError;
import io.ballerina.stdlib.sql.parameterprocessor.AbstractStatementParameterProcessor;
import io.ballerina.stdlib.sql.utils.Utils;
import io.ballerina.stdlib.time.util.TimeValueHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.sql.Array;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;

public class DefaultStatementParameterProcessor
extends AbstractStatementParameterProcessor {
    private static final Object lock = new Object();
    private static volatile DefaultStatementParameterProcessor instance;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultStatementParameterProcessor getInstance() {
        if (instance == null) {
            Object object = lock;
            synchronized (object) {
                if (instance == null) {
                    instance = new DefaultStatementParameterProcessor();
                }
            }
        }
        return instance;
    }

    private Object[] getArrayData(Object value) throws DataError, SQLException {
        Type type = TypeUtils.getType((Object)value);
        if (value == null || type.getTag() != 32) {
            return new Object[]{null, null};
        }
        Type elementType = ((ArrayType)type).getElementType();
        int typeTag = elementType.getTag();
        switch (typeTag) {
            case 1: {
                return this.getIntArrayData(value);
            }
            case 3: {
                return this.getFloatArrayData(value);
            }
            case 4: {
                return this.getDecimalArrayData(value);
            }
            case 5: {
                return this.getStringArrayData(value);
            }
            case 6: {
                return this.getBooleanArrayData(value);
            }
            case 32: {
                return this.getNestedArrayData(value);
            }
        }
        return this.getCustomArrayData(value);
    }

    protected Object[] getIntValueArrayData(Object value, String type, String dataType) throws DataError {
        int arrayLength = ((BArray)value).size();
        Short[] arrayData = new Short[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof Integer || innerValue instanceof Long) {
                arrayData[i] = ((Number)innerValue).shortValue();
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, dataType);
        }
        return new Object[]{arrayData, type};
    }

    protected Object[] getDecimalValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        BigDecimal[] arrayData = new BigDecimal[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof Double || innerValue instanceof Long) {
                arrayData[i] = new BigDecimal(((Number)innerValue).doubleValue(), MathContext.DECIMAL64);
                continue;
            }
            if (innerValue instanceof Integer || innerValue instanceof Float) {
                arrayData[i] = new BigDecimal(((Number)innerValue).doubleValue(), MathContext.DECIMAL32);
                continue;
            }
            if (innerValue instanceof BDecimal) {
                arrayData[i] = ((BDecimal)innerValue).decimalValue();
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, "Decimal Array");
        }
        return new Object[]{arrayData, "DECIMAL"};
    }

    protected Object[] getRealValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        Double[] arrayData = new Double[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof Double) {
                arrayData[i] = ((Number)innerValue).doubleValue();
                continue;
            }
            if (innerValue instanceof Long || innerValue instanceof Float || innerValue instanceof Integer) {
                arrayData[i] = ((Number)innerValue).doubleValue();
                continue;
            }
            if (innerValue instanceof BDecimal) {
                arrayData[i] = ((BDecimal)innerValue).decimalValue().doubleValue();
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, "Real Array");
        }
        return new Object[]{arrayData, "REAL"};
    }

    protected Object[] getNumericValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        BigDecimal[] arrayData = new BigDecimal[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof Double || innerValue instanceof Long) {
                arrayData[i] = new BigDecimal(((Number)innerValue).doubleValue(), MathContext.DECIMAL64);
                continue;
            }
            if (innerValue instanceof Integer || innerValue instanceof Float) {
                arrayData[i] = new BigDecimal(((Number)innerValue).doubleValue(), MathContext.DECIMAL32);
                continue;
            }
            if (innerValue instanceof BDecimal) {
                arrayData[i] = ((BDecimal)innerValue).decimalValue();
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, "Numeric Array");
        }
        return new Object[]{arrayData, "NUMERIC"};
    }

    protected Object[] getDoubleValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        Double[] arrayData = new Double[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof Double) {
                arrayData[i] = ((Number)innerValue).doubleValue();
                continue;
            }
            if (innerValue instanceof Long || innerValue instanceof Float || innerValue instanceof Integer) {
                arrayData[i] = ((Number)innerValue).doubleValue();
                continue;
            }
            if (innerValue instanceof BDecimal) {
                arrayData[i] = ((BDecimal)innerValue).decimalValue().doubleValue();
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, "Double Array");
        }
        return new Object[]{arrayData, "DOUBLE"};
    }

    protected Object[] getFloatValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        Double[] arrayData = new Double[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof Double) {
                arrayData[i] = ((Number)innerValue).doubleValue();
                continue;
            }
            if (innerValue instanceof Long || innerValue instanceof Float || innerValue instanceof Integer) {
                arrayData[i] = ((Number)innerValue).doubleValue();
                continue;
            }
            if (innerValue instanceof BDecimal) {
                arrayData[i] = ((BDecimal)innerValue).decimalValue().doubleValue();
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, "Float Array");
        }
        return new Object[]{arrayData, "FLOAT"};
    }

    protected Object[] getCharValueArrayData(Object value) throws DataError {
        return this.getStringValueArrayData(value, "CHAR");
    }

    protected Object[] getVarcharValueArrayData(Object value) throws DataError {
        return this.getStringValueArrayData(value, "VARCHAR");
    }

    protected Object[] getNvarcharValueArrayData(Object value) throws DataError {
        return this.getStringValueArrayData(value, "NVARCHAR");
    }

    protected Object[] getDateTimeValueArrayData(Object value) throws DataError {
        return this.getDateTimeAndTimestampValueArrayData(value);
    }

    protected Object[] getTimestampValueArrayData(Object value) throws DataError {
        return this.getDateTimeAndTimestampValueArrayData(value);
    }

    protected Object[] getBooleanValueArrayData(Object value) throws DataError {
        return this.getBitAndBooleanValueArrayData(value, "BOOLEAN");
    }

    protected Object[] getDateValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        Date[] arrayData = new Date[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            try {
                if (innerValue == null) {
                    arrayData[i] = null;
                    continue;
                }
                if (innerValue instanceof BString) {
                    arrayData[i] = Date.valueOf(innerValue.toString());
                    continue;
                }
                if (innerValue instanceof BMap) {
                    BMap dateMap = (BMap)innerValue;
                    int year = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"year")));
                    int month = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"month")));
                    int day = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"day")));
                    arrayData[i] = Date.valueOf(year + "-" + month + "-" + day);
                    continue;
                }
                throw Utils.throwInvalidParameterError(innerValue, "Date Array");
            }
            catch (ArithmeticException | IllegalArgumentException ex) {
                throw new ConversionError("Unsupported value: " + String.valueOf(innerValue) + " for Date Array");
            }
        }
        return new Object[]{arrayData, "DATE"};
    }

    protected Object[] getTimeValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        Object[] arrayData = new Object[arrayLength];
        boolean containsTimeZone = false;
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            try {
                if (innerValue == null) {
                    arrayData[i] = null;
                    continue;
                }
                if (innerValue instanceof BString) {
                    arrayData[i] = Time.valueOf(innerValue.toString());
                    continue;
                }
                if (innerValue instanceof BMap) {
                    BMap timeMap = (BMap)innerValue;
                    int hour = Math.toIntExact(timeMap.getIntValue(StringUtils.fromString((String)"hour")));
                    int minute = Math.toIntExact(timeMap.getIntValue(StringUtils.fromString((String)"minute")));
                    BDecimal second = BDecimal.valueOf((int)0);
                    if (timeMap.containsKey((Object)StringUtils.fromString((String)"second"))) {
                        second = (BDecimal)timeMap.get((Object)StringUtils.fromString((String)"second"));
                    }
                    int zoneHours = 0;
                    int zoneMinutes = 0;
                    BDecimal zoneSeconds = BDecimal.valueOf((int)0);
                    boolean timeZone = false;
                    if (timeMap.containsKey((Object)StringUtils.fromString((String)"utcOffset"))) {
                        timeZone = true;
                        containsTimeZone = true;
                        BMap zoneMap = (BMap)timeMap.get((Object)StringUtils.fromString((String)"utcOffset"));
                        zoneHours = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"hours")));
                        zoneMinutes = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"minutes")));
                        if (zoneMap.containsKey((Object)StringUtils.fromString((String)"seconds"))) {
                            zoneSeconds = (BDecimal)zoneMap.get((Object)StringUtils.fromString((String)"seconds"));
                        }
                    }
                    int intSecond = second.decimalValue().setScale(0, RoundingMode.FLOOR).intValue();
                    int intNanoSecond = second.decimalValue().subtract(new BigDecimal(intSecond)).multiply(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA).setScale(0, RoundingMode.HALF_UP).intValue();
                    LocalTime localTime = LocalTime.of(hour, minute, intSecond, intNanoSecond);
                    if (timeZone) {
                        int intZoneSecond = zoneSeconds.decimalValue().setScale(0, RoundingMode.HALF_UP).intValue();
                        OffsetTime offsetTime = OffsetTime.of(localTime, ZoneOffset.ofHoursMinutesSeconds(zoneHours, zoneMinutes, intZoneSecond));
                        arrayData[i] = offsetTime;
                        continue;
                    }
                    arrayData[i] = Time.valueOf(localTime);
                    continue;
                }
                throw Utils.throwInvalidParameterError(innerValue, "Time Array");
            }
            catch (ArithmeticException | IllegalArgumentException ex) {
                throw new ConversionError("Unsupported value " + String.valueOf(innerValue) + " for Time Array");
            }
        }
        if (containsTimeZone) {
            return new Object[]{arrayData, "TIME_WITH_TIMEZONE"};
        }
        return new Object[]{arrayData, "TIME"};
    }

    protected Object[] getBinaryValueArrayData(Object value) throws DataError {
        return this.getBinaryAndBlobValueArrayData(value, "BINARY");
    }

    protected Object[] getVarbinaryValueArrayData(Object value) throws DataError {
        return this.getBinaryAndBlobValueArrayData(value, "VARBINARY");
    }

    protected Object[] getBitValueArrayData(Object value) throws DataError {
        return this.getBitAndBooleanValueArrayData(value, "BIT");
    }

    private Object[] getBitAndBooleanValueArrayData(Object value, String type) throws DataError {
        int arrayLength = ((BArray)value).size();
        Boolean[] arrayData = new Boolean[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof BString) {
                arrayData[i] = Boolean.parseBoolean(innerValue.toString());
                continue;
            }
            if (innerValue instanceof Integer || innerValue instanceof Long) {
                long lVal = ((Number)innerValue).longValue();
                if (lVal == 1L || lVal == 0L) {
                    arrayData[i] = lVal == 1L;
                    continue;
                }
                throw new DataError("Only 1 or 0 can be passed for " + type + " SQL Type, but found :" + lVal);
            }
            if (innerValue instanceof Boolean) {
                arrayData[i] = innerValue;
                continue;
            }
            throw Utils.throwInvalidParameterError(innerValue, type + " Array");
        }
        return new Object[]{arrayData, type};
    }

    private Object[] getBinaryAndBlobValueArrayData(Object value, String type) throws DataError {
        int arrayLength = ((BArray)value).size();
        Object[] arrayData = new Object[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            if (innerValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (innerValue instanceof BArray) {
                BArray arrayValue = (BArray)innerValue;
                if (arrayValue.getElementType().getTag() == 2) {
                    arrayData[i] = arrayValue.getBytes();
                    continue;
                }
                throw Utils.throwInvalidParameterError(innerValue, type);
            }
            if (innerValue instanceof BObject) {
                BObject objectValue = (BObject)innerValue;
                ObjectType objectValueType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)objectValue));
                if (objectValueType.getName().equalsIgnoreCase("ReadableByteChannel") && objectValueType.getPackage().toString().equalsIgnoreCase(IOUtils.getIOPackage().toString())) {
                    try {
                        Channel byteChannel = (Channel)objectValue.getNativeData("byteChannel");
                        arrayData[i] = DefaultStatementParameterProcessor.toByteArray(byteChannel.getInputStream());
                        continue;
                    }
                    catch (IOException e) {
                        throw new DataError("Error processing byte channel ", e);
                    }
                }
                throw Utils.throwInvalidParameterError(innerValue, type + " Array");
            }
            throw Utils.throwInvalidParameterError(innerValue, type);
        }
        return new Object[]{arrayData, type};
    }

    public static byte[] toByteArray(InputStream in) throws IOException {
        int len;
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((len = in.read(buffer)) != -1) {
            os.write(buffer, 0, len);
        }
        return os.toByteArray();
    }

    private Object[] getDateTimeAndTimestampValueArrayData(Object value) throws DataError {
        int arrayLength = ((BArray)value).size();
        boolean containsTimeZone = false;
        BArray array = (BArray)value;
        Object[] arrayData = new Object[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            Object innerValue = array.get((long)i);
            try {
                if (innerValue == null) {
                    arrayData[i] = null;
                    continue;
                }
                if (innerValue instanceof BString) {
                    DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                    arrayData[i] = LocalDateTime.parse(innerValue.toString(), formatter);
                    continue;
                }
                if (innerValue instanceof BArray) {
                    BArray dateTimeStruct = (BArray)innerValue;
                    ZonedDateTime zonedDt = TimeValueHandler.createZonedDateTimeFromUtc((BArray)dateTimeStruct);
                    Timestamp timestamp = new Timestamp(zonedDt.toInstant().toEpochMilli());
                    arrayData[i] = timestamp;
                    continue;
                }
                if (innerValue instanceof BMap) {
                    BMap dateMap = (BMap)innerValue;
                    int year = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"year")));
                    int month = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"month")));
                    int day = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"day")));
                    int hour = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"hour")));
                    int minute = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"minute")));
                    BDecimal second = BDecimal.valueOf((int)0);
                    if (dateMap.containsKey((Object)StringUtils.fromString((String)"second"))) {
                        second = (BDecimal)dateMap.get((Object)StringUtils.fromString((String)"second"));
                    }
                    int zoneHours = 0;
                    int zoneMinutes = 0;
                    BDecimal zoneSeconds = BDecimal.valueOf((int)0);
                    boolean timeZone = false;
                    if (dateMap.containsKey((Object)StringUtils.fromString((String)"utcOffset"))) {
                        timeZone = true;
                        containsTimeZone = true;
                        BMap zoneMap = (BMap)dateMap.get((Object)StringUtils.fromString((String)"utcOffset"));
                        zoneHours = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"hours")));
                        zoneMinutes = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"minutes")));
                        if (zoneMap.containsKey((Object)StringUtils.fromString((String)"seconds"))) {
                            zoneSeconds = (BDecimal)zoneMap.get((Object)StringUtils.fromString((String)"seconds"));
                        }
                    }
                    int intSecond = second.decimalValue().setScale(0, RoundingMode.FLOOR).intValue();
                    int intNanoSecond = second.decimalValue().subtract(new BigDecimal(intSecond)).multiply(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA).setScale(0, RoundingMode.HALF_UP).intValue();
                    LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, intSecond, intNanoSecond);
                    if (timeZone) {
                        int intZoneSecond = zoneSeconds.decimalValue().setScale(0, RoundingMode.HALF_UP).intValue();
                        OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.ofHoursMinutesSeconds(zoneHours, zoneMinutes, intZoneSecond));
                        arrayData[i] = offsetDateTime;
                        continue;
                    }
                    arrayData[i] = Timestamp.valueOf(localDateTime);
                    continue;
                }
                throw Utils.throwInvalidParameterError(value, "TIMESTAMP ARRAY");
            }
            catch (ArithmeticException | DateTimeParseException e) {
                throw new ConversionError("Unsupported value: " + String.valueOf(innerValue) + " for DateTime Array");
            }
        }
        if (containsTimeZone) {
            return new Object[]{arrayData, "TIMESTAMP_WITH_TIMEZONE"};
        }
        return new Object[]{arrayData, "TIMESTAMP"};
    }

    private Object[] getStringValueArrayData(Object value, String type) throws DataError {
        int arrayLength = ((BArray)value).size();
        String[] arrayData = new String[arrayLength];
        BArray array = (BArray)value;
        for (int i = 0; i < arrayLength; ++i) {
            Object arrayValue = array.get((long)i);
            if (arrayValue == null) {
                arrayData[i] = null;
                continue;
            }
            if (arrayValue instanceof BString) {
                arrayData[i] = arrayValue.toString();
                continue;
            }
            throw Utils.throwInvalidParameterError(value, type + " Array");
        }
        return new Object[]{arrayData, type};
    }

    private Object[] getStructData(Connection conn, Object value) throws SQLException, DataError {
        Type type = TypeUtils.getType((Object)value);
        if (value == null || type.getTag() != 47 && type.getTag() != 24) {
            return new Object[]{null, null};
        }
        String structuredSQLType = type.getName().toUpperCase(Locale.getDefault());
        Map structFields = ((StructureType)type).getFields();
        int fieldCount = structFields.size();
        Object[] structData = new Object[fieldCount];
        Iterator fieldIterator = structFields.values().iterator();
        block5: for (int i = 0; i < fieldCount; ++i) {
            Field field = (Field)fieldIterator.next();
            Object bValue = ((BMap)value).get((Object)StringUtils.fromString((String)field.getFieldName()));
            int typeTag = TypeUtils.getReferredType((Type)field.getFieldType()).getTag();
            switch (typeTag) {
                case 1: 
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    structData[i] = bValue;
                    continue block5;
                }
                case 32: {
                    this.getArrayStructData(field, structData, structuredSQLType, i, bValue);
                    continue block5;
                }
                case 24: {
                    this.getRecordStructData(conn, structData, i, bValue);
                    continue block5;
                }
                default: {
                    this.getCustomStructData(value);
                }
            }
        }
        return new Object[]{structData, structuredSQLType};
    }

    @Override
    protected void setXml(Connection connection, PreparedStatement preparedStatement, int index, BXml value) throws SQLException, DataError {
        preparedStatement.setObject(index, (Object)value.getTextValue(), 2009);
    }

    @Override
    protected int setCustomBOpenRecord(Connection connection, PreparedStatement preparedStatement, int index, Object value, boolean returnType) throws DataError, SQLException {
        throw new DataError("Unsupported type passed in column index: " + index);
    }

    private void setString(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        if (value == null) {
            preparedStatement.setString(index, null);
        } else {
            preparedStatement.setString(index, value.toString());
        }
    }

    private void setNString(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        if (value == null) {
            preparedStatement.setNString(index, null);
        } else {
            preparedStatement.setNString(index, value.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBooleanValue(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 16);
            return;
        } else if (value instanceof BString) {
            preparedStatement.setBoolean(index, Boolean.parseBoolean(value.toString()));
            return;
        } else if (value instanceof Integer || value instanceof Long) {
            long lVal = ((Number)value).longValue();
            if (lVal != 1L && lVal != 0L) throw new DataError("Only 1 or 0 can be passed for " + sqlType + " SQL Type, but found :" + lVal);
            preparedStatement.setBoolean(index, lVal == 1L);
            return;
        } else {
            if (!(value instanceof Boolean)) throw Utils.throwInvalidParameterError(value, sqlType);
            preparedStatement.setBoolean(index, (Boolean)value);
        }
    }

    private void setNumericAndDecimal(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 3);
        } else if (value instanceof Double || value instanceof Long) {
            preparedStatement.setBigDecimal(index, new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL64));
        } else if (value instanceof Integer || value instanceof Float) {
            preparedStatement.setBigDecimal(index, new BigDecimal(((Number)value).doubleValue(), MathContext.DECIMAL32));
        } else if (value instanceof BDecimal) {
            preparedStatement.setBigDecimal(index, ((BDecimal)value).decimalValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setBinaryAndBlob(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setBytes(index, null);
            return;
        }
        if (value instanceof BArray) {
            BArray arrayValue = (BArray)value;
            if (arrayValue.getElementType().getTag() != 2) throw Utils.throwInvalidParameterError(value, sqlType);
            preparedStatement.setBytes(index, arrayValue.getBytes());
            return;
        }
        if (!(value instanceof BObject)) throw Utils.throwInvalidParameterError(value, sqlType);
        BObject objectValue = (BObject)value;
        ObjectType objectValueType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)objectValue));
        if (!objectValueType.getName().equalsIgnoreCase("ReadableByteChannel") || !objectValueType.getPackage().toString().equalsIgnoreCase(IOUtils.getIOPackage().toString())) throw Utils.throwInvalidParameterError(value, sqlType);
        try {
            Channel byteChannel = (Channel)objectValue.getNativeData("byteChannel");
            preparedStatement.setBinaryStream(index, byteChannel.getInputStream());
            return;
        }
        catch (IOException e) {
            throw new DataError("Error when processing binary stream.", e);
        }
    }

    private void setClobAndNclob(Connection connection, PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 2005);
        } else {
            Clob clob = sqlType.equalsIgnoreCase("NClobValue") ? connection.createNClob() : connection.createClob();
            if (value instanceof BString) {
                clob.setString(1L, value.toString());
                preparedStatement.setClob(index, clob);
            } else if (value instanceof BObject) {
                BObject objectValue = (BObject)value;
                ObjectType objectValueType = (ObjectType)TypeUtils.getReferredType((Type)objectValue.getType());
                if (objectValueType.getName().equalsIgnoreCase("ReadableCharacterChannel") && objectValueType.getPackage().toString().equalsIgnoreCase(IOUtils.getIOPackage().toString())) {
                    CharacterChannel charChannel = (CharacterChannel)objectValue.getNativeData("char_channel");
                    preparedStatement.setCharacterStream(index, (Reader)new CharacterChannelReader(charChannel));
                } else {
                    throw Utils.throwInvalidParameterError(value, sqlType);
                }
            }
        }
    }

    private void setRefAndStruct(Connection connection, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        Object[] structData = this.getStructData(connection, value);
        Object[] dataArray = (Object[])structData[0];
        String structuredSQLType = (String)structData[1];
        if (dataArray == null) {
            preparedStatement.setNull(index, 2002);
        } else {
            Struct struct = connection.createStruct(structuredSQLType, dataArray);
            preparedStatement.setObject(index, struct);
        }
    }

    private void setDateTimeAndTimestamp(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        boolean timeZone = false;
        if (value == null) {
            preparedStatement.setTimestamp(index, null);
        } else if (value instanceof BString) {
            preparedStatement.setString(index, value.toString());
        } else if (value instanceof BArray) {
            BArray dateTimeStruct = (BArray)value;
            ZonedDateTime zonedDt = TimeValueHandler.createZonedDateTimeFromUtc((BArray)dateTimeStruct);
            Timestamp timestamp = new Timestamp(zonedDt.toInstant().toEpochMilli());
            preparedStatement.setTimestamp(index, timestamp, Calendar.getInstance(TimeZone.getTimeZone(Constants.TIMEZONE_UTC.getValue())));
        } else if (value instanceof BMap) {
            try {
                BMap dateMap = (BMap)value;
                int year = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"year")));
                int month = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"month")));
                int day = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"day")));
                int hour = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"hour")));
                int minute = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"minute")));
                BDecimal second = BDecimal.valueOf((int)0);
                if (dateMap.containsKey((Object)StringUtils.fromString((String)"second"))) {
                    second = (BDecimal)dateMap.get((Object)StringUtils.fromString((String)"second"));
                }
                int zoneHours = 0;
                int zoneMinutes = 0;
                BDecimal zoneSeconds = BDecimal.valueOf((int)0);
                if (dateMap.containsKey((Object)StringUtils.fromString((String)"utcOffset"))) {
                    timeZone = true;
                    BMap zoneMap = (BMap)dateMap.get((Object)StringUtils.fromString((String)"utcOffset"));
                    zoneHours = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"hours")));
                    zoneMinutes = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"minutes")));
                    if (zoneMap.containsKey((Object)StringUtils.fromString((String)"seconds"))) {
                        zoneSeconds = (BDecimal)zoneMap.get((Object)StringUtils.fromString((String)"seconds"));
                    }
                }
                int intSecond = second.decimalValue().setScale(0, RoundingMode.FLOOR).intValue();
                int intNanoSecond = second.decimalValue().subtract(new BigDecimal(intSecond)).multiply(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA).setScale(0, RoundingMode.HALF_UP).intValue();
                LocalDateTime localDateTime = LocalDateTime.of(year, month, day, hour, minute, intSecond, intNanoSecond);
                if (timeZone) {
                    int intZoneSecond = zoneSeconds.decimalValue().setScale(0, RoundingMode.HALF_UP).intValue();
                    OffsetDateTime offsetDateTime = OffsetDateTime.of(localDateTime, ZoneOffset.ofHoursMinutesSeconds(zoneHours, zoneMinutes, intZoneSecond));
                    preparedStatement.setObject(index, (Object)offsetDateTime, 2014);
                }
                preparedStatement.setTimestamp(index, Timestamp.valueOf(localDateTime));
            }
            catch (Throwable ex) {
                if (ex instanceof SQLFeatureNotSupportedException) {
                    if (timeZone) {
                        throw new TypeMismatchError("time:Civil with offset value does not support in this database. " + ex.getMessage());
                    }
                    throw new TypeMismatchError("Unsupported type: " + ex.getMessage());
                }
                throw new ConversionError("Unsupported value: " + String.valueOf(value) + " for " + sqlType);
            }
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    public int getCustomOutParameterType(BObject typedValue) throws DataError, SQLException {
        String sqlType = TypeUtils.getType((Object)typedValue).getName();
        throw new DataError("Unsupported OutParameter type: " + sqlType);
    }

    @Override
    protected int getCustomSQLType(BObject typedValue) throws DataError, SQLException {
        String sqlType = typedValue.getType().getName();
        throw new DataError("Unsupported SQL type: " + sqlType);
    }

    @Override
    protected void setCustomSqlTypedParam(Connection connection, PreparedStatement preparedStatement, int index, BObject typedValue) throws SQLException, DataError {
        String sqlType = typedValue.getType().getName();
        throw new DataError("Unsupported SQL type: " + sqlType);
    }

    protected Object[] getCustomArrayData(Object value) throws DataError, SQLException {
        throw Utils.throwInvalidParameterError(value, "ArrayValue");
    }

    protected Object[] getCustomStructData(Object value) throws DataError, SQLException {
        Type type = TypeUtils.getType((Object)value);
        String structuredSQLType = type.getName().toUpperCase(Locale.getDefault());
        throw new DataError("unsupported data type of " + structuredSQLType + " specified for struct parameter");
    }

    @Override
    protected void setVarchar(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        this.setString(preparedStatement, index, value);
    }

    @Override
    protected void setVarcharArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getVarcharValueArrayData(value));
    }

    @Override
    protected void setText(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        this.setString(preparedStatement, index, value);
    }

    @Override
    protected void setChar(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        this.setString(preparedStatement, index, value);
    }

    @Override
    protected void setCharArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getCharValueArrayData(value));
    }

    @Override
    protected void setNChar(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        this.setNString(preparedStatement, index, value);
    }

    @Override
    protected void setNVarchar(PreparedStatement preparedStatement, int index, Object value) throws SQLException {
        this.setNString(preparedStatement, index, value);
    }

    @Override
    protected void setNVarcharArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getNvarcharValueArrayData(value));
    }

    @Override
    protected void setBit(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setBooleanValue(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setBitArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getBitValueArrayData(value));
    }

    @Override
    protected void setBoolean(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setBooleanValue(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setBooleanArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getBooleanValueArrayData(value));
    }

    @Override
    protected void setInteger(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 4);
        } else if (value instanceof Integer || value instanceof Long) {
            preparedStatement.setInt(index, ((Number)value).intValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setIntegerArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getIntValueArrayData(value, "INTEGER", "Int Array"));
    }

    @Override
    protected void setBigInt(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, -5);
        } else if (value instanceof Integer || value instanceof Long) {
            preparedStatement.setLong(index, ((Number)value).longValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setBigIntArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getIntValueArrayData(value, "BIGINT", "Bigint Array"));
    }

    @Override
    protected void setSmallInt(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 5);
        } else if (value instanceof Integer || value instanceof Long) {
            preparedStatement.setShort(index, ((Number)value).shortValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setSmallIntArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getIntValueArrayData(value, "SMALLINT", "Smallint Array"));
    }

    @Override
    protected void setFloat(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 6);
        } else if (value instanceof Double || value instanceof Long || value instanceof Float || value instanceof Integer) {
            preparedStatement.setFloat(index, ((Number)value).floatValue());
        } else if (value instanceof BDecimal) {
            preparedStatement.setFloat(index, ((BDecimal)value).decimalValue().floatValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setFloatArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getFloatValueArrayData(value));
    }

    @Override
    protected void setReal(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 6);
        } else if (value instanceof Double) {
            preparedStatement.setDouble(index, ((Number)value).doubleValue());
        } else if (value instanceof Long || value instanceof Float || value instanceof Integer) {
            preparedStatement.setFloat(index, ((Number)value).floatValue());
        } else if (value instanceof BDecimal) {
            preparedStatement.setFloat(index, ((BDecimal)value).decimalValue().floatValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setRealArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getRealValueArrayData(value));
    }

    @Override
    protected void setDouble(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setNull(index, 8);
        } else if (value instanceof Double || value instanceof Long || value instanceof Float || value instanceof Integer) {
            preparedStatement.setDouble(index, ((Number)value).doubleValue());
        } else if (value instanceof BDecimal) {
            preparedStatement.setDouble(index, ((BDecimal)value).decimalValue().doubleValue());
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setDoubleArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getDoubleValueArrayData(value));
    }

    @Override
    protected void setNumeric(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setNumericAndDecimal(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setNumericArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getNumericValueArrayData(value));
    }

    @Override
    protected void setDecimal(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setNumericAndDecimal(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setDecimalArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getDecimalValueArrayData(value));
    }

    @Override
    protected void setBinary(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setBinaryAndBlob(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setBinaryArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getBinaryValueArrayData(value));
    }

    @Override
    protected void setVarBinary(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setBinaryAndBlob(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setVarBinaryArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getVarbinaryValueArrayData(value));
    }

    @Override
    protected void setBlob(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setBinaryAndBlob(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setClob(Connection connection, PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setClobAndNclob(connection, preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setNClob(Connection connection, PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setClobAndNclob(connection, preparedStatement, sqlType, index, value);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected void setRow(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setRowId(index, null);
            return;
        } else {
            if (!(value instanceof BArray)) throw Utils.throwInvalidParameterError(value, sqlType);
            BArray arrayValue = (BArray)value;
            if (arrayValue.getElementType().getTag() != 2) throw Utils.throwInvalidParameterError(value, sqlType);
            RowId rowId = () -> ((BArray)arrayValue).getBytes();
            preparedStatement.setRowId(index, rowId);
        }
    }

    @Override
    protected void setStruct(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setRefAndStruct(conn, preparedStatement, index, value);
    }

    @Override
    protected void setRef(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setRefAndStruct(conn, preparedStatement, index, value);
    }

    @Override
    protected void setArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getArrayData(value));
    }

    private void setPreparedStatement(Connection conn, PreparedStatement preparedStatement, int index, Object[] arrayData) throws SQLException {
        if (arrayData[0] != null) {
            Array array = conn.createArrayOf((String)arrayData[1], (Object[])arrayData[0]);
            preparedStatement.setArray(index, array);
        } else {
            preparedStatement.setArray(index, null);
        }
    }

    @Override
    protected void setDateTime(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setDateTimeAndTimestamp(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setDateTimeArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getDateTimeValueArrayData(value));
    }

    @Override
    protected void setTimestamp(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        this.setDateTimeAndTimestamp(preparedStatement, sqlType, index, value);
    }

    @Override
    protected void setTimestampArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getTimestampValueArrayData(value));
    }

    @Override
    protected void setDate(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        if (value == null) {
            preparedStatement.setDate(index, null);
        } else {
            Date date;
            block6: {
                try {
                    if (value instanceof BString) {
                        date = Date.valueOf(value.toString());
                        break block6;
                    }
                    if (value instanceof BMap) {
                        BMap dateMap = (BMap)value;
                        int year = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"year")));
                        int month = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"month")));
                        int day = Math.toIntExact(dateMap.getIntValue(StringUtils.fromString((String)"day")));
                        date = Date.valueOf(year + "-" + month + "-" + day);
                        break block6;
                    }
                    throw Utils.throwInvalidParameterError(value, sqlType);
                }
                catch (ArithmeticException | IllegalArgumentException e) {
                    throw new ConversionError("Unsupported value: " + String.valueOf(value) + " for Date Value");
                }
            }
            preparedStatement.setDate(index, date);
        }
    }

    @Override
    protected void setDateArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getDateValueArrayData(value));
    }

    @Override
    protected void setTime(PreparedStatement preparedStatement, String sqlType, int index, Object value) throws SQLException, DataError {
        boolean timeZone = false;
        if (value == null) {
            preparedStatement.setTime(index, null);
        } else if (value instanceof BString) {
            preparedStatement.setString(index, value.toString());
        } else if (value instanceof BMap) {
            try {
                BMap timeMap = (BMap)value;
                int hour = Math.toIntExact(timeMap.getIntValue(StringUtils.fromString((String)"hour")));
                int minute = Math.toIntExact(timeMap.getIntValue(StringUtils.fromString((String)"minute")));
                BDecimal second = BDecimal.valueOf((int)0);
                if (timeMap.containsKey((Object)StringUtils.fromString((String)"second"))) {
                    second = (BDecimal)timeMap.get((Object)StringUtils.fromString((String)"second"));
                }
                int zoneHours = 0;
                int zoneMinutes = 0;
                BDecimal zoneSeconds = BDecimal.valueOf((int)0);
                if (timeMap.containsKey((Object)StringUtils.fromString((String)"utcOffset"))) {
                    timeZone = true;
                    BMap zoneMap = (BMap)timeMap.get((Object)StringUtils.fromString((String)"utcOffset"));
                    zoneHours = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"hours")));
                    zoneMinutes = Math.toIntExact(zoneMap.getIntValue(StringUtils.fromString((String)"minutes")));
                    if (zoneMap.containsKey((Object)StringUtils.fromString((String)"seconds"))) {
                        zoneSeconds = (BDecimal)zoneMap.get((Object)StringUtils.fromString((String)"seconds"));
                    }
                }
                int intSecond = second.decimalValue().setScale(0, RoundingMode.FLOOR).intValue();
                int intNanoSecond = second.decimalValue().subtract(new BigDecimal(intSecond)).multiply(io.ballerina.stdlib.time.util.Constants.ANALOG_GIGA).setScale(0, RoundingMode.HALF_UP).intValue();
                LocalTime localTime = LocalTime.of(hour, minute, intSecond, intNanoSecond);
                if (timeZone) {
                    int intZoneSecond = zoneSeconds.decimalValue().setScale(0, RoundingMode.HALF_UP).intValue();
                    OffsetTime offsetTime = OffsetTime.of(localTime, ZoneOffset.ofHoursMinutesSeconds(zoneHours, zoneMinutes, intZoneSecond));
                    preparedStatement.setObject(index, (Object)offsetTime, 2013);
                }
                preparedStatement.setTime(index, Time.valueOf(localTime));
            }
            catch (Throwable ex) {
                if (ex instanceof SQLFeatureNotSupportedException) {
                    if (timeZone) {
                        throw new TypeMismatchError("time:Civil with offset value does not support in this database. " + ex.getMessage());
                    }
                    throw new TypeMismatchError("Unsupported type: " + ex.getMessage());
                }
                throw new ConversionError("Unsupported value: " + String.valueOf(value) + " for Time Value");
            }
        } else {
            throw Utils.throwInvalidParameterError(value, sqlType);
        }
    }

    @Override
    protected void setTimeArray(Connection conn, PreparedStatement preparedStatement, int index, Object value) throws SQLException, DataError {
        this.setPreparedStatement(conn, preparedStatement, index, this.getTimeValueArrayData(value));
    }

    protected Object[] getIntArrayData(Object value) {
        int arrayLength = ((BArray)value).size();
        Long[] arrayData = new Long[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            arrayData[i] = ((BArray)value).getInt((long)i);
        }
        return new Object[]{arrayData, "BIGINT"};
    }

    protected Object[] getFloatArrayData(Object value) {
        int arrayLength = ((BArray)value).size();
        Double[] arrayData = new Double[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            arrayData[i] = ((BArray)value).getFloat((long)i);
        }
        return new Object[]{arrayData, "DOUBLE"};
    }

    protected Object[] getDecimalArrayData(Object value) {
        int arrayLength = ((BArray)value).size();
        BigDecimal[] arrayData = new BigDecimal[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            arrayData[i] = ((BDecimal)((BArray)value).getRefValue((long)i)).value();
        }
        return new Object[]{arrayData, "DECIMAL"};
    }

    protected Object[] getStringArrayData(Object value) {
        int arrayLength = ((BArray)value).size();
        String[] arrayData = new String[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            arrayData[i] = ((BArray)value).getBString((long)i).getValue();
        }
        return new Object[]{arrayData, "VARCHAR"};
    }

    protected Object[] getBooleanArrayData(Object value) {
        int arrayLength = ((BArray)value).size();
        Boolean[] arrayData = new Boolean[arrayLength];
        for (int i = 0; i < arrayLength; ++i) {
            arrayData[i] = ((BArray)value).getBoolean((long)i);
        }
        return new Object[]{arrayData, "BOOLEAN"};
    }

    protected Object[] getNestedArrayData(Object value) throws DataError {
        Type type = TypeUtils.getType((Object)value);
        Type elementType = ((ArrayType)type).getElementType();
        Type elementTypeOfArrayElement = ((ArrayType)elementType).getElementType();
        if (elementTypeOfArrayElement.getTag() == 2) {
            BArray arrayValue = (BArray)value;
            byte[][] arrayData = new byte[arrayValue.size()][];
            for (int i = 0; i < arrayData.length; ++i) {
                arrayData[i] = ((BArray)arrayValue.get((long)i)).getBytes();
            }
            return new Object[]{arrayData, "BINARY"};
        }
        throw Utils.throwInvalidParameterError(value, "ArrayValue");
    }

    protected void getRecordStructData(Connection conn, Object[] structData, int i, Object bValue) throws SQLException, DataError {
        Object structValue = bValue;
        Object[] internalStructData = this.getStructData(conn, structValue);
        Object[] dataArray = (Object[])internalStructData[0];
        String internalStructType = (String)internalStructData[1];
        structData[i] = structValue = conn.createStruct(internalStructType, dataArray);
    }

    protected void getArrayStructData(Field field, Object[] structData, String structuredSQLType, int i, Object bValue) throws DataError {
        Type elementType = ((ArrayType)field.getFieldType()).getElementType();
        if (elementType.getTag() != 2) {
            throw new DataError("unsupported data type of " + structuredSQLType + " specified for struct parameter");
        }
        structData[i] = ((BArray)bValue).getBytes();
    }
}

