/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp;

import io.ballerina.stdlib.udp.Dispatcher;
import io.ballerina.stdlib.udp.UdpListenerHandler;
import io.ballerina.stdlib.udp.UdpService;
import io.ballerina.stdlib.udp.Utils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.PromiseCombiner;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;

public class UdpListener {
    private Channel channel;
    private final Bootstrap listenerBootstrap = new Bootstrap();

    public UdpListener(InetSocketAddress localAddress, InetSocketAddress remoteAddress, EventLoopGroup group, CompletableFuture<Object> balFuture, final UdpService udpService) {
        ((Bootstrap)((Bootstrap)this.listenerBootstrap.group(group)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(this){

            protected void initChannel(Channel ch) {
                ch.pipeline().addLast("udpListenerHandler", (ChannelHandler)new UdpListenerHandler(udpService));
            }
        });
        if (remoteAddress != null) {
            this.connect(remoteAddress, localAddress, balFuture);
        } else {
            this.listenerBootstrap.bind((SocketAddress)localAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    this.channel = future.channel();
                    balFuture.complete(null);
                } else {
                    balFuture.complete((Object)Utils.createUdpError("Unable to initialize UDP Listener: " + future.cause().getMessage()));
                }
            }));
        }
    }

    public static void send(DatagramPacket datagram, Channel channel, CompletableFuture<Object> balFuture) {
        LinkedList<DatagramPacket> fragments = Utils.fragmentDatagram(datagram);
        PromiseCombiner promiseCombiner = UdpListener.getPromiseCombiner(fragments, channel);
        promiseCombiner.finish((Promise)channel.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (future.isSuccess()) {
                balFuture.complete(null);
            } else {
                balFuture.complete((Object)Utils.createUdpError("Failed to send data: " + future.cause().getMessage()));
            }
        })));
    }

    public static void send(UdpService udpService, DatagramPacket datagram, Channel channel) {
        LinkedList<DatagramPacket> fragments = Utils.fragmentDatagram(datagram);
        PromiseCombiner promiseCombiner = UdpListener.getPromiseCombiner(fragments, channel);
        promiseCombiner.finish((Promise)channel.newPromise().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            if (!future.isSuccess()) {
                Dispatcher.invokeOnError(udpService, "Failed to send data.");
            }
        })));
    }

    private static PromiseCombiner getPromiseCombiner(LinkedList<DatagramPacket> fragments, Channel channel) {
        PromiseCombiner promiseCombiner = new PromiseCombiner((EventExecutor)ImmediateEventExecutor.INSTANCE);
        while (!fragments.isEmpty()) {
            if (!channel.isWritable()) continue;
            promiseCombiner.add((Future)channel.writeAndFlush((Object)fragments.poll()));
        }
        return promiseCombiner;
    }

    private void connect(SocketAddress remoteAddress, SocketAddress localAddress, CompletableFuture<Object> balFuture) {
        this.listenerBootstrap.connect(remoteAddress, localAddress).addListener((GenericFutureListener)((ChannelFutureListener)future -> {
            this.channel = future.channel();
            if (future.isSuccess()) {
                balFuture.complete(null);
            } else {
                balFuture.complete((Object)Utils.createUdpError("Can't connect to remote host."));
            }
        }));
    }

    public void close(CompletableFuture<Object> balFuture) throws InterruptedException {
        if (this.channel != null) {
            this.channel.close().sync().addListener((GenericFutureListener)((ChannelFutureListener)future -> {
                if (future.isSuccess()) {
                    balFuture.complete(null);
                } else {
                    balFuture.complete((Object)Utils.createUdpError("Failed to gracefully shutdown the Listener."));
                }
            }));
        }
    }
}

