/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.udp.Constants;
import io.netty.buffer.ByteBuf;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.concurrent.CompletableFuture;

public final class Utils {
    private static Module udpModule = null;

    private Utils() {
    }

    public static BError createUdpError(String errMsg) {
        return ErrorCreator.createError((Module)Utils.getUdpPackage(), (String)Constants.ErrorType.Error.errorType(), (BString)StringUtils.fromString((String)errMsg), null, null);
    }

    public static BMap<BString, Object> createReadOnlyDatagramWithSenderAddress(DatagramPacket datagramPacket) {
        byte[] byteContent = new byte[((ByteBuf)datagramPacket.content()).readableBytes()];
        ((ByteBuf)datagramPacket.content()).readBytes(byteContent);
        HashMap<String, Integer> datagramContent = new HashMap<String, Integer>();
        datagramContent.put("remotePort", ((InetSocketAddress)datagramPacket.sender()).getPort());
        datagramContent.put("remoteHost", (Integer)StringUtils.fromString((String)((InetSocketAddress)datagramPacket.sender()).getHostName()));
        datagramContent.put("data", (Integer)ValueCreator.createArrayValue((byte[])byteContent));
        BMap datagram = ValueCreator.createReadonlyRecordValue((Module)Utils.getUdpPackage(), (String)"Datagram", datagramContent);
        return datagram;
    }

    static BMap<BString, Object> createReadonlyDatagramWithRecipientAddress(DatagramPacket datagramPacket) {
        byte[] byteContent = new byte[((ByteBuf)datagramPacket.content()).readableBytes()];
        ((ByteBuf)datagramPacket.content()).readBytes(byteContent);
        HashMap<String, Integer> datagramContent = new HashMap<String, Integer>();
        datagramContent.put("remotePort", ((InetSocketAddress)datagramPacket.recipient()).getPort());
        datagramContent.put("remoteHost", (Integer)StringUtils.fromString((String)((InetSocketAddress)datagramPacket.recipient()).getHostName()));
        datagramContent.put("data", (Integer)ValueCreator.createArrayValue((byte[])byteContent));
        BMap datagram = ValueCreator.createReadonlyRecordValue((Module)Utils.getUdpPackage(), (String)"Datagram", datagramContent);
        return datagram;
    }

    static BArray getReadonlyBytesFromDatagram(DatagramPacket datagramPacket) {
        byte[] byteContent = new byte[((ByteBuf)datagramPacket.content()).readableBytes()];
        ((ByteBuf)datagramPacket.content()).readBytes(byteContent);
        return ValueCreator.createReadonlyArrayValue((byte[])byteContent);
    }

    static LinkedList<DatagramPacket> fragmentDatagram(DatagramPacket datagram) {
        ByteBuf content = (ByteBuf)datagram.content();
        int contentSize = content.readableBytes();
        LinkedList<DatagramPacket> fragments = new LinkedList<DatagramPacket>();
        while (contentSize > 0) {
            if (contentSize > 8192) {
                fragments.add(datagram.replace(content.readBytes(8192)));
                contentSize -= 8192;
                continue;
            }
            fragments.add(datagram.replace(((ByteBuf)datagram.content()).readBytes(contentSize)));
            contentSize = 0;
        }
        return fragments;
    }

    public static Module getUdpPackage() {
        return Utils.getModule();
    }

    public static void setModule(Environment env) {
        udpModule = env.getCurrentModule();
    }

    public static Module getModule() {
        return udpModule;
    }

    public static Object getResult(CompletableFuture<Object> balFuture) {
        try {
            return balFuture.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw ErrorCreator.createError((Throwable)e);
        }
        catch (Throwable throwable) {
            throw ErrorCreator.createError((Throwable)throwable);
        }
    }

    public static InetSocketAddress getLocalInetSocketAddress(BObject client, BMap<BString, Object> config) {
        BString host = config.getStringValue(StringUtils.fromString((String)"localHost"));
        InetSocketAddress localAddress = host == null ? new InetSocketAddress(0) : new InetSocketAddress(host.getValue(), 0);
        double timeout = ((BDecimal)config.get((Object)StringUtils.fromString((String)"timeout"))).floatValue();
        client.addNativeData("timeout", (Object)timeout);
        return localAddress;
    }
}

