/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.nativeclient;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.udp.UdpClient;
import io.ballerina.stdlib.udp.UdpFactory;
import io.ballerina.stdlib.udp.Utils;
import io.netty.buffer.Unpooled;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public final class Client {
    private Client() {
    }

    public static Object init(Environment env, BObject client, BMap<BString, Object> config) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            BString host = config.getStringValue(StringUtils.fromString((String)"localHost"));
            InetSocketAddress localAddress = Utils.getLocalInetSocketAddress(client, config);
            UdpClient udpClient = UdpFactory.getInstance().createUdpClient(localAddress, balFuture);
            client.addNativeData("client", (Object)udpClient);
            return Utils.getResult(balFuture);
        });
    }

    public static Object receive(Environment env, BObject client) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            double readTimeOut = (Double)client.getNativeData("timeout");
            UdpClient udpClient = (UdpClient)client.getNativeData("client");
            udpClient.receiveData(readTimeOut, balFuture);
            return Utils.getResult(balFuture);
        });
    }

    public static Object send(Environment env, BObject client, BMap<BString, Object> datagram) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            String host = datagram.getStringValue(StringUtils.fromString((String)"remoteHost")).getValue();
            int port = datagram.getIntValue(StringUtils.fromString((String)"remotePort")).intValue();
            BArray data = datagram.getArrayValue(StringUtils.fromString((String)"data"));
            byte[] byteContent = data.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(Unpooled.wrappedBuffer((byte[])byteContent), new InetSocketAddress(host, port));
            UdpClient udpClient = (UdpClient)client.getNativeData("client");
            udpClient.sendData(datagramPacket, balFuture);
            return Utils.getResult(balFuture);
        });
    }

    public static Object close(Environment env, BObject client) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            UdpClient udpClient = (UdpClient)client.getNativeData("client");
            udpClient.close(balFuture);
            return Utils.getResult(balFuture);
        });
    }
}

