/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.udp.nativelistener;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.udp.UdpListener;
import io.ballerina.stdlib.udp.Utils;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.socket.DatagramPacket;
import java.net.InetSocketAddress;
import java.util.concurrent.CompletableFuture;

public final class Caller {
    private Caller() {
    }

    public static Object sendBytes(Environment env, BObject caller, BArray data) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            byte[] byteContent = data.getBytes();
            String remoteHost = caller.getStringValue(StringUtils.fromString((String)"remoteHost")).getValue();
            int remotePort = (Integer)caller.get(StringUtils.fromString((String)"remotePort"));
            InetSocketAddress remoteAddress = new InetSocketAddress(remoteHost, remotePort);
            DatagramPacket datagram = new DatagramPacket(Unpooled.wrappedBuffer((byte[])byteContent), remoteAddress);
            Channel channel = (Channel)caller.getNativeData("Channel");
            UdpListener.send(datagram, channel, balFuture);
            return Utils.getResult(balFuture);
        });
    }

    public static Object sendDatagram(Environment env, BObject caller, BMap<BString, Object> datagram) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            String host = datagram.getStringValue(StringUtils.fromString((String)"remoteHost")).getValue();
            int port = datagram.getIntValue(StringUtils.fromString((String)"remotePort")).intValue();
            BArray data = datagram.getArrayValue(StringUtils.fromString((String)"data"));
            byte[] byteContent = data.getBytes();
            DatagramPacket datagramPacket = new DatagramPacket(Unpooled.wrappedBuffer((byte[])byteContent), new InetSocketAddress(host, port));
            Channel channel = (Channel)caller.getNativeData("Channel");
            UdpListener.send(datagramPacket, channel, balFuture);
            return Utils.getResult(balFuture);
        });
    }
}

