/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.compiler.analyzer;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.UnaryExpressionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.sql.compiler.SQLDiagnosticsCodes;
import io.ballerina.stdlib.sql.compiler.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class ConnectionPoolConfigAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext ctx) {
        if (Utils.hasCompilationErrors(ctx)) {
            return;
        }
        Optional varSymOptional = ctx.semanticModel().symbol(ctx.node());
        if (varSymOptional.isPresent()) {
            TypeSymbol typeSymbol = ((VariableSymbol)varSymOptional.get()).typeDescriptor();
            if (!this.isConnectionPoolVariable(typeSymbol)) {
                return;
            }
            Optional optionalInitializer = ctx.node() instanceof VariableDeclarationNode ? ((VariableDeclarationNode)ctx.node()).initializer() : ((ModuleVariableDeclarationNode)ctx.node()).initializer();
            if (optionalInitializer.isEmpty()) {
                return;
            }
            ExpressionNode initializer = (ExpressionNode)optionalInitializer.get();
            if (!(initializer instanceof MappingConstructorExpressionNode)) {
                return;
            }
            SeparatedNodeList fields = ((MappingConstructorExpressionNode)initializer).fields();
            block10: for (MappingFieldNode field : fields) {
                String name = ((SpecificFieldNode)field).fieldName().toString().trim().replaceAll("\"|\\n", "");
                ExpressionNode valueNode = (ExpressionNode)((SpecificFieldNode)field).valueExpr().get();
                switch (name) {
                    case "maxOpenConnections": {
                        int maxOpenConnections = Integer.parseInt(this.getTerminalNodeValue((Node)valueNode, "1"));
                        if (maxOpenConnections >= 1) continue block10;
                        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(SQLDiagnosticsCodes.SQL_101.getCode(), SQLDiagnosticsCodes.SQL_101.getMessage(), SQLDiagnosticsCodes.SQL_101.getSeverity());
                        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)valueNode.location(), (Object[])new Object[0]));
                        continue block10;
                    }
                    case "minIdleConnections": {
                        int minIdleConnection = Integer.parseInt(this.getTerminalNodeValue((Node)valueNode, "0"));
                        if (minIdleConnection >= 0) continue block10;
                        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(SQLDiagnosticsCodes.SQL_102.getCode(), SQLDiagnosticsCodes.SQL_102.getMessage(), SQLDiagnosticsCodes.SQL_102.getSeverity());
                        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)valueNode.location(), (Object[])new Object[0]));
                        continue block10;
                    }
                    case "maxConnectionLifeTime": {
                        float maxConnectionTime = Float.parseFloat(this.getTerminalNodeValue((Node)valueNode, "30"));
                        if (!(maxConnectionTime < 0.0f) && (!(maxConnectionTime > 0.0f) || !(maxConnectionTime < 30.0f))) continue block10;
                        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(SQLDiagnosticsCodes.SQL_103.getCode(), SQLDiagnosticsCodes.SQL_103.getMessage(), SQLDiagnosticsCodes.SQL_103.getSeverity());
                        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)valueNode.location(), (Object[])new Object[0]));
                        continue block10;
                    }
                }
            }
        }
    }

    private String getTerminalNodeValue(Node valueNode, String defaultValue) {
        Object value = defaultValue;
        if (valueNode instanceof BasicLiteralNode) {
            value = ((BasicLiteralNode)valueNode).literalToken().text();
        } else if (valueNode instanceof UnaryExpressionNode) {
            UnaryExpressionNode unaryExpressionNode = (UnaryExpressionNode)valueNode;
            value = String.valueOf(unaryExpressionNode.unaryOperator()) + ((BasicLiteralNode)unaryExpressionNode.expression()).literalToken().text();
        }
        return ((String)value).replaceAll("\"|\\n", "");
    }

    private boolean isConnectionPoolVariable(TypeSymbol type) {
        if (type.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)type).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(this::isSQLConnectionPoolVariable);
        }
        if (type.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isSQLConnectionPoolVariable((TypeReferenceTypeSymbol)type);
        }
        return false;
    }

    private boolean isSQLConnectionPoolVariable(TypeReferenceTypeSymbol typeSymbol) {
        if (typeSymbol.typeDescriptor().typeKind() == TypeDescKind.RECORD) {
            ModuleSymbol moduleSymbol = (ModuleSymbol)typeSymbol.getModule().get();
            return "sql".equals(moduleSymbol.getName().get()) && "ballerina".equals(moduleSymbol.id().orgName()) && ((String)typeSymbol.definition().getName().get()).equals("ConnectionPool");
        }
        return false;
    }
}

