/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HTTPInterceptorServicesRegistry;
import io.ballerina.stdlib.http.api.HTTPServicesRegistry;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpResource;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.InterceptorResource;
import io.ballerina.stdlib.http.api.InterceptorService;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.ResourceDispatcher;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.api.service.signature.AllHeaderParams;
import io.ballerina.stdlib.http.api.service.signature.AllPathParams;
import io.ballerina.stdlib.http.api.service.signature.AllQueryParams;
import io.ballerina.stdlib.http.api.service.signature.NonRecurringParam;
import io.ballerina.stdlib.http.api.service.signature.ParamHandler;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import io.ballerina.stdlib.http.api.service.signature.PayloadParam;
import io.ballerina.stdlib.http.api.service.signature.RemoteMethodParamHandler;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.URIUtil;
import io.netty.handler.codec.http.HttpHeaderNames;
import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpDispatcher {
    private static final Logger logger = LoggerFactory.getLogger(HttpDispatcher.class);

    public static HttpService findService(HTTPServicesRegistry servicesRegistry, HttpCarbonMessage inboundReqMsg, boolean forInterceptors) {
        try {
            List<String> sortedServiceURIs;
            Map<String, HttpService> servicesOnInterface;
            String hostName = inboundReqMsg.getHeader(HttpHeaderNames.HOST.toString());
            if (hostName != null && servicesRegistry.getServicesMapHolder(hostName) != null) {
                servicesOnInterface = servicesRegistry.getServicesByHost(hostName);
                sortedServiceURIs = servicesRegistry.getSortedServiceURIsByHost(hostName);
            } else if (servicesRegistry.getServicesMapHolder("b7a.default") != null) {
                servicesOnInterface = servicesRegistry.getServicesByHost("b7a.default");
                sortedServiceURIs = servicesRegistry.getSortedServiceURIsByHost("b7a.default");
            } else {
                String localAddress = inboundReqMsg.getProperty("LOCAL_ADDRESS").toString();
                String message = "no service has registered for listener : " + localAddress;
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR, message);
            }
            String rawUri = (String)inboundReqMsg.getProperty("TO");
            HashMap<String, Map<String, String>> matrixParams = new HashMap<String, Map<String, String>>();
            String uriWithoutMatrixParams = URIUtil.extractMatrixParams(rawUri, matrixParams, inboundReqMsg);
            String[] rawPathAndQuery = HttpDispatcher.extractRawPathAndQuery(uriWithoutMatrixParams);
            String basePath = servicesRegistry.findTheMostSpecificBasePath(rawPathAndQuery[0], servicesOnInterface, sortedServiceURIs);
            if (basePath == null) {
                String message = "no matching service found for path: " + rawPathAndQuery[0];
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR, message);
            }
            HttpService service = servicesOnInterface.get(basePath);
            if (!forInterceptors) {
                HttpDispatcher.setInboundReqProperties(inboundReqMsg, rawPathAndQuery[0], basePath, rawPathAndQuery[1]);
                inboundReqMsg.setProperty("RAW_URI", rawUri);
                inboundReqMsg.setProperty("TO", uriWithoutMatrixParams);
                inboundReqMsg.setProperty("MATRIX_PARAMS", matrixParams);
            }
            return service;
        }
        catch (Exception e) {
            if (!(e instanceof BError)) {
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR, e.getMessage());
            }
            throw e;
        }
    }

    public static HttpService findSingleService(HTTPServicesRegistry servicesRegistry) {
        HttpService service = null;
        for (Object holder : servicesRegistry.getServicesMapByHost().values().toArray()) {
            HTTPServicesRegistry.ServicesMapHolder mapHolder = (HTTPServicesRegistry.ServicesMapHolder)holder;
            if (mapHolder.getServicesByBasePath().values().size() != 1 || service != null) {
                return null;
            }
            service = (HttpService)mapHolder.getServicesByBasePath().values().toArray()[0];
        }
        return service;
    }

    public static InterceptorService findInterceptorService(HTTPInterceptorServicesRegistry servicesRegistry, HttpCarbonMessage inboundReqMsg, boolean isResponsePath) {
        try {
            List<String> sortedServiceURIs;
            Map<String, InterceptorService> servicesOnInterface;
            String hostName = inboundReqMsg.getHeader(HttpHeaderNames.HOST.toString());
            if (hostName != null && servicesRegistry.getServicesMapHolder(hostName) != null) {
                servicesOnInterface = servicesRegistry.getServicesByHost(hostName);
                sortedServiceURIs = servicesRegistry.getSortedServiceURIsByHost(hostName);
            } else if (servicesRegistry.getServicesMapHolder("b7a.default") != null) {
                servicesOnInterface = servicesRegistry.getServicesByHost("b7a.default");
                sortedServiceURIs = servicesRegistry.getSortedServiceURIsByHost("b7a.default");
            } else {
                String localAddress = inboundReqMsg.getProperty("LOCAL_ADDRESS").toString();
                String message = "no service has registered for listener : " + localAddress;
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR, message);
            }
            if (isResponsePath) {
                InterceptorService[] services = servicesOnInterface.values().toArray(new InterceptorService[0]);
                return services[0];
            }
            String rawUri = (String)inboundReqMsg.getProperty("TO");
            inboundReqMsg.setProperty("RAW_URI", rawUri);
            HashMap<String, Map<String, String>> matrixParams = new HashMap<String, Map<String, String>>();
            String uriWithoutMatrixParams = URIUtil.extractMatrixParams(rawUri, matrixParams, inboundReqMsg);
            inboundReqMsg.setProperty("TO", uriWithoutMatrixParams);
            inboundReqMsg.setProperty("MATRIX_PARAMS", matrixParams);
            String[] rawPathAndQuery = HttpDispatcher.extractRawPathAndQuery(uriWithoutMatrixParams);
            String basePath = servicesRegistry.findTheMostSpecificBasePath(rawPathAndQuery[0], servicesOnInterface, sortedServiceURIs);
            if (basePath == null) {
                String message = "no matching service found for path: " + rawPathAndQuery[0];
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR, message);
            }
            InterceptorService service = servicesOnInterface.get(basePath);
            HttpDispatcher.setInboundReqProperties(inboundReqMsg, rawPathAndQuery[0], basePath, rawPathAndQuery[1]);
            return service;
        }
        catch (Exception e) {
            if (!(e instanceof BError)) {
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_SERVICE_NOT_FOUND_ERROR, e.getMessage());
            }
            throw e;
        }
    }

    private static String[] extractRawPathAndQuery(String uriWithoutMatrixParams) {
        String[] rawPathAndQuery = new String[2];
        String[] splittedUri = uriWithoutMatrixParams.split("\\?");
        rawPathAndQuery[0] = splittedUri[0];
        rawPathAndQuery[1] = splittedUri.length > 1 ? splittedUri[1] : null;
        return rawPathAndQuery;
    }

    private static void setInboundReqProperties(HttpCarbonMessage inboundReqMsg, String rawPath, String basePath, String rawQuery) {
        String subPath = URIUtil.getSubPath(rawPath, basePath);
        inboundReqMsg.setProperty("BASE_PATH", basePath);
        inboundReqMsg.setProperty("SUB_PATH", subPath);
        inboundReqMsg.setProperty("QUERY_STR", rawQuery);
        inboundReqMsg.setProperty("RAW_QUERY_STR", rawQuery);
    }

    public static URI getValidatedURI(String uriStr) {
        URI requestUri;
        try {
            requestUri = URI.create(uriStr);
        }
        catch (IllegalArgumentException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        return requestUri;
    }

    public static HttpResource findResource(HTTPServicesRegistry servicesRegistry, HttpCarbonMessage inboundMessage) {
        String protocol = (String)inboundMessage.getProperty("PROTOCOL");
        if (protocol == null) {
            throw HttpUtil.createHttpError("protocol not defined in the incoming request", HttpErrorType.INTERNAL_REQ_DISPATCHING_ERROR);
        }
        HttpService service = HttpDispatcher.findService(servicesRegistry, inboundMessage, false);
        if (service == null) {
            throw HttpUtil.createHttpError("no Service found to handle the service request", HttpErrorType.INTERNAL_REQ_DISPATCHING_ERROR);
        }
        return (HttpResource)ResourceDispatcher.findResource(service, inboundMessage);
    }

    public static InterceptorResource findInterceptorResource(HTTPInterceptorServicesRegistry servicesRegistry, HttpCarbonMessage inboundMessage) {
        String protocol = (String)inboundMessage.getProperty("PROTOCOL");
        if (protocol == null) {
            throw HttpUtil.createHttpError("protocol not defined in the incoming request", HttpErrorType.INTERNAL_REQ_DISPATCHING_ERROR);
        }
        InterceptorService service = HttpDispatcher.findInterceptorService(servicesRegistry, inboundMessage, false);
        if (service == null) {
            throw HttpUtil.createHttpError("no Service found to handle the service request", HttpErrorType.INTERNAL_REQ_DISPATCHING_ERROR);
        }
        return (InterceptorResource)ResourceDispatcher.findResource(service, inboundMessage);
    }

    public static Object[] getRemoteSignatureParameters(InterceptorService service, BObject response, BObject caller, HttpCarbonMessage httpCarbonMessage, Runtime runtime) {
        BObject inRequest = null;
        BObject requestCtx = HttpDispatcher.getRequestCtx(httpCarbonMessage, runtime);
        BObject entityObj = (BObject)httpCarbonMessage.getProperty("EntityObj");
        HttpDispatcher.populatePropertiesForResponsePath(httpCarbonMessage, requestCtx);
        BError error = (BError)((Object)httpCarbonMessage.getProperty("INTERCEPTOR_SERVICE_ERROR"));
        RemoteMethodParamHandler paramHandler = service.getRemoteMethodParamHandler();
        int sigParamCount = paramHandler.getParamCount();
        Object[] paramFeed = new Object[sigParamCount];
        for (Parameter param : paramHandler.getOtherParamList()) {
            String typeName;
            switch (typeName = param.getTypeName()) {
                case "RequestContext": {
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = requestCtx;
                    break;
                }
                case "Request": {
                    if (inRequest == null) {
                        inRequest = HttpDispatcher.createRequest(httpCarbonMessage, entityObj);
                    }
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = inRequest;
                    break;
                }
                case "error": {
                    if (error == null) {
                        error = HttpDispatcher.createError();
                    }
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = error;
                    break;
                }
                case "Response": {
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = response;
                    break;
                }
                case "Caller": {
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = caller;
                    break;
                }
            }
        }
        return paramFeed;
    }

    private static void populatePropertiesForResponsePath(HttpCarbonMessage httpCarbonMessage, BObject requestCtx) {
        requestCtx.addNativeData("INTERCEPTOR_SERVICE", (Object)true);
        int interceptorId = httpCarbonMessage.getProperty("RESPONSE_INTERCEPTOR_INDEX") == null ? 0 : (Integer)httpCarbonMessage.getProperty("RESPONSE_INTERCEPTOR_INDEX") + 1;
        requestCtx.addNativeData("RESPONSE_INTERCEPTOR_INDEX", (Object)interceptorId);
        requestCtx.addNativeData("INTERCEPTOR_SERVICE_TYPE", (Object)"ResponseInterceptor");
        requestCtx.addNativeData("REQUEST_CONTEXT_NEXT", (Object)false);
    }

    public static Object[] getSignatureParameters(Resource resource, HttpCarbonMessage httpCarbonMessage, BMap<BString, Object> endpointConfig, Runtime runtime) {
        BObject inRequest = null;
        BObject requestCtx = HttpDispatcher.getRequestCtx(httpCarbonMessage, runtime);
        HttpDispatcher.populatePropertiesForRequestPath(resource, httpCarbonMessage, requestCtx);
        BObject entityObj = (BObject)httpCarbonMessage.getProperty("EntityObj");
        BError error = (BError)((Object)httpCarbonMessage.getProperty("INTERCEPTOR_SERVICE_ERROR"));
        BObject httpCaller = HttpDispatcher.getCaller(resource, httpCarbonMessage, endpointConfig);
        ParamHandler paramHandler = resource.getParamHandler();
        Type[] parameterTypes = HttpUtil.getParameterTypes((FunctionType)resource.getBalResource());
        int sigParamCount = parameterTypes.length;
        Object[] paramFeed = new Object[sigParamCount];
        boolean treatNilableAsOptional = resource.isTreatNilableAsOptional();
        for (Parameter param : paramHandler.getParamList()) {
            String typeName;
            switch (typeName = param.getTypeName()) {
                case "path": {
                    ((AllPathParams)param).populateFeed(paramFeed, httpCarbonMessage, resource);
                    break;
                }
                case "Caller": {
                    int index = ((NonRecurringParam)param).getIndex();
                    httpCaller.set(HttpConstants.CALLER_PRESENT_FIELD, (Object)true);
                    paramFeed[index] = httpCaller;
                    break;
                }
                case "RequestContext": {
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = requestCtx;
                    break;
                }
                case "error": {
                    if (error == null) {
                        error = HttpDispatcher.createError();
                    }
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = error;
                    break;
                }
                case "Request": {
                    if (inRequest == null) {
                        inRequest = HttpDispatcher.createRequest(httpCarbonMessage, entityObj);
                    }
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = inRequest;
                    break;
                }
                case "Headers": {
                    if (inRequest == null) {
                        inRequest = HttpDispatcher.createRequest(httpCarbonMessage, entityObj);
                    }
                    int index = ((NonRecurringParam)param).getIndex();
                    paramFeed[index] = HttpDispatcher.createHeadersObject(inRequest);
                    break;
                }
                case "query": {
                    ((AllQueryParams)param).populateFeed(httpCarbonMessage, paramHandler, paramFeed, treatNilableAsOptional);
                    break;
                }
                case "header": {
                    ((AllHeaderParams)param).populateFeed(httpCarbonMessage, paramFeed, treatNilableAsOptional);
                    break;
                }
                case "payload": {
                    if (inRequest == null) {
                        inRequest = HttpDispatcher.createRequest(httpCarbonMessage, entityObj);
                    }
                    ((PayloadParam)param).populateFeed(inRequest, httpCarbonMessage, paramFeed);
                    break;
                }
            }
        }
        return paramFeed;
    }

    private static BObject getRequestCtx(HttpCarbonMessage httpCarbonMessage, Runtime runtime) {
        BObject requestCtx = (BObject)httpCarbonMessage.getProperty("RequestContext");
        return requestCtx != null ? requestCtx : HttpDispatcher.createRequestContext(httpCarbonMessage, runtime);
    }

    private static void populatePropertiesForRequestPath(Resource resource, HttpCarbonMessage httpCarbonMessage, BObject requestCtx) {
        if (resource instanceof InterceptorResource) {
            requestCtx.addNativeData("INTERCEPTOR_SERVICE", (Object)true);
        } else {
            requestCtx.addNativeData("INTERCEPTOR_SERVICE", (Object)false);
        }
        int interceptorId = httpCarbonMessage.getProperty("REQUEST_INTERCEPTOR_INDEX") == null ? 0 : (Integer)httpCarbonMessage.getProperty("REQUEST_INTERCEPTOR_INDEX") - 1;
        requestCtx.addNativeData("REQUEST_INTERCEPTOR_INDEX", (Object)interceptorId);
        requestCtx.addNativeData("REQUEST_CONTEXT_NEXT", (Object)false);
        requestCtx.addNativeData("INTERCEPTOR_SERVICE_TYPE", (Object)"RequestInterceptor");
    }

    private static BObject createRequest(HttpCarbonMessage httpCarbonMessage, BObject entityObj) {
        BObject inRequest = ValueCreatorUtils.createRequestObject();
        BObject inRequestEntity = entityObj == null ? ValueCreatorUtils.createEntityObject() : entityObj;
        HttpUtil.populateInboundRequest(inRequest, inRequestEntity, httpCarbonMessage);
        return inRequest;
    }

    static BObject getCaller(Resource resource, HttpCarbonMessage httpCarbonMessage, BMap<BString, Object> endpointConfig) {
        String resourceAccessor = resource.getBalResource().getAccessor().toUpperCase(Locale.getDefault());
        BObject httpCaller = Objects.isNull(httpCarbonMessage.getProperty("Caller")) ? ValueCreatorUtils.createCallerObject(httpCarbonMessage, resourceAccessor) : (BObject)httpCarbonMessage.getProperty("Caller");
        Object currentResourceAccessor = httpCaller.get(HttpConstants.RESOURCE_ACCESSOR);
        if (Objects.isNull(currentResourceAccessor) || HttpUtil.isDefaultResource(((BString)currentResourceAccessor).getValue())) {
            httpCaller.set(HttpConstants.RESOURCE_ACCESSOR, (Object)StringUtils.fromString((String)resourceAccessor));
        }
        HttpUtil.enrichHttpCallerWithConnectionInfo(httpCaller, httpCarbonMessage, resource, endpointConfig);
        HttpUtil.enrichHttpCallerWithNativeData(httpCaller, httpCarbonMessage, endpointConfig);
        httpCarbonMessage.setProperty("Caller", httpCaller);
        return httpCaller;
    }

    static BObject createRequestContext(HttpCarbonMessage httpCarbonMessage, Runtime runtime) {
        BObject requestContext = ValueCreatorUtils.createRequestContextObject();
        String authHeader = httpCarbonMessage.getHeader("authorization");
        if (Objects.nonNull(authHeader) && authHeader.startsWith("Bearer ")) {
            HttpDispatcher.addJwtValuesToRequestContext(runtime, requestContext, authHeader);
        }
        BArray interceptors = httpCarbonMessage.getProperty("INTERCEPTORS") instanceof BArray ? (BArray)httpCarbonMessage.getProperty("INTERCEPTORS") : null;
        requestContext.addNativeData("INTERCEPTORS", (Object)interceptors);
        requestContext.addNativeData("TARGET_SERVICE", httpCarbonMessage.getProperty("TARGET_SERVICE"));
        requestContext.addNativeData("REQUEST_CONTEXT_NEXT", (Object)false);
        httpCarbonMessage.setProperty("RequestContext", requestContext);
        return requestContext;
    }

    private static void addJwtValuesToRequestContext(Runtime runtime, BObject requestContext, String authHeader) {
        Object decodedJwt = HttpDispatcher.invokeJwtDecode(runtime, authHeader);
        if (Objects.nonNull(decodedJwt)) {
            BMap requestCtxMembers = requestContext.getMapValue(HttpConstants.REQUEST_CTX_MEMBERS);
            requestCtxMembers.put((Object)HttpConstants.JWT_INFORMATION, decodedJwt);
        }
    }

    private static Object invokeJwtDecode(Runtime runtime, String authHeader) {
        Object[] jwtInformation = new Object[1];
        String[] splitValues = authHeader.split(" ");
        if (splitValues.length != 2) {
            return null;
        }
        Object result = runtime.callMethod(ValueCreator.createObjectValue((Module)ModuleUtils.getHttpPackage(), (String)"JwtDecoder", (Object[])new Object[0]), "decodeJwt", null, new Object[]{StringUtils.fromString((String)splitValues[1])});
        if (!(result instanceof Exception)) {
            jwtInformation[0] = result;
        }
        return jwtInformation[0];
    }

    static BError createError() {
        return ErrorCreator.createError((BString)StringUtils.fromString((String)"new error"));
    }

    private static Object createHeadersObject(BObject inRequest) {
        BObject headers = ValueCreatorUtils.createHeadersObject();
        headers.set(HttpConstants.HEADER_REQUEST_FIELD, (Object)inRequest);
        return headers;
    }

    public static boolean shouldDiffer(Resource resource) {
        return resource != null && resource.getParamHandler().isPayloadBindingRequired();
    }

    private HttpDispatcher() {
    }
}

