/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnectorListener;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.ResponseHandle;
import java.util.concurrent.CompletableFuture;

public class GetNextPromise
extends AbstractHTTPAction {
    public static Object getNextPromise(Environment env, BObject clientObj, BObject handleObj) {
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, clientConnector, handleObj, null);
            ResponseHandle responseHandle = (ResponseHandle)handleObj.getNativeData("transport_handle");
            if (responseHandle == null) {
                throw HttpUtil.createHttpError("invalid http handle");
            }
            clientConnector.getNextPushPromise(responseHandle).setPushPromiseListener(new PromiseListener(dataContext));
            return ExternUtils.getResult(balFuture);
        });
    }

    private GetNextPromise() {
    }

    private static class PromiseListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        PromiseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public void onPushPromise(Http2PushPromise pushPromise) {
            BObject pushPromiseObj = ValueCreator.createObjectValue((Module)ModuleUtils.getHttpPackage(), (String)"PushPromise", (Object[])new Object[]{StringUtils.fromString((String)pushPromise.getPath()), StringUtils.fromString((String)pushPromise.getMethod())});
            HttpUtil.populatePushPromiseStruct(pushPromiseObj, pushPromise);
            this.dataContext.notifyInboundResponseStatus(pushPromiseObj, null);
        }
    }
}

