/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.transport.message.FullHttpMessageListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpMessageDataStreamer;
import io.ballerina.stdlib.mime.nativeimpl.MimeDataSourceBuilder;
import io.ballerina.stdlib.mime.nativeimpl.MimeEntityBody;
import io.ballerina.stdlib.mime.util.EntityBodyChannel;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import io.ballerina.stdlib.mime.util.EntityWrapper;
import io.ballerina.stdlib.mime.util.MimeUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternHttpDataSourceBuilder
extends MimeDataSourceBuilder {
    private static final Logger log = LoggerFactory.getLogger(ExternHttpDataSourceBuilder.class);

    public static Object getNonBlockingByteArray(Environment env, BObject entityObj) {
        Object transportMessage = entityObj.getNativeData("transport_message");
        if (EntityBodyHandler.isStreamingRequired((BObject)entityObj) || transportMessage == null) {
            return ExternHttpDataSourceBuilder.getByteArray((BObject)entityObj);
        }
        try {
            Object messageDataSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
            if (messageDataSource != null) {
                return ExternHttpDataSourceBuilder.getAlreadyBuiltByteArray((BObject)entityObj, (Object)messageDataSource);
            }
        }
        catch (Exception exception) {
            return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"blob");
        }
        return env.yieldAndRun(() -> {
            try {
                CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
                ExternHttpDataSourceBuilder.constructNonBlockingDataSource(balFuture, entityObj, SourceType.BLOB);
                return ExternUtils.getResult(balFuture);
            }
            catch (Exception exception) {
                return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"blob");
            }
        });
    }

    public static Object getNonBlockingJson(Environment env, BObject entityObj) {
        if (EntityBodyHandler.isStreamingRequired((BObject)entityObj)) {
            return ExternHttpDataSourceBuilder.getJson((BObject)entityObj);
        }
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
            if (dataSource != null) {
                return ExternHttpDataSourceBuilder.getAlreadyBuiltJson((Object)dataSource);
            }
        }
        catch (Exception exception) {
            return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"json");
        }
        return env.yieldAndRun(() -> {
            try {
                CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
                ExternHttpDataSourceBuilder.constructNonBlockingDataSource(balFuture, entityObj, SourceType.JSON);
                return ExternUtils.getResult(balFuture);
            }
            catch (Exception exception) {
                return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"json");
            }
        });
    }

    public static Object getNonBlockingText(Environment env, BObject entityObj) {
        if (EntityBodyHandler.isStreamingRequired((BObject)entityObj)) {
            return ExternHttpDataSourceBuilder.getText((BObject)entityObj);
        }
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
            if (dataSource != null) {
                return StringUtils.fromString((String)MimeUtil.getMessageAsString((Object)dataSource));
            }
        }
        catch (Exception exception) {
            return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"text");
        }
        return env.yieldAndRun(() -> {
            try {
                CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
                ExternHttpDataSourceBuilder.constructNonBlockingDataSource(balFuture, entityObj, SourceType.TEXT);
                return ExternUtils.getResult(balFuture);
            }
            catch (Exception exception) {
                return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"text");
            }
        });
    }

    public static Object getNonBlockingXml(Environment env, BObject entityObj) {
        if (EntityBodyHandler.isStreamingRequired((BObject)entityObj)) {
            return ExternHttpDataSourceBuilder.getXml((BObject)entityObj);
        }
        try {
            Object dataSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
            if (dataSource != null) {
                return ExternHttpDataSourceBuilder.getAlreadyBuiltXml((Object)dataSource);
            }
        }
        catch (Exception exception) {
            return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"text");
        }
        return env.yieldAndRun(() -> {
            try {
                CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
                ExternHttpDataSourceBuilder.constructNonBlockingDataSource(balFuture, entityObj, SourceType.XML);
                return ExternUtils.getResult(balFuture);
            }
            catch (Exception exception) {
                return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)"text");
            }
        });
    }

    public static Object getByteChannel(BObject entityObj) {
        ExternHttpDataSourceBuilder.populateInputStream(entityObj);
        return MimeEntityBody.getByteChannel((BObject)entityObj);
    }

    public static void populateInputStream(BObject entityObj) {
        Object dataSource = entityObj.getNativeData("message_datasource");
        if (Objects.nonNull(dataSource)) {
            return;
        }
        HttpCarbonMessage httpCarbonMessage = (HttpCarbonMessage)entityObj.getNativeData("transport_message");
        if (Objects.nonNull(httpCarbonMessage)) {
            HttpMessageDataStreamer httpMessageDataStreamer = new HttpMessageDataStreamer(httpCarbonMessage);
            long contentLength = HttpUtil.extractContentLength(httpCarbonMessage);
            if (contentLength > 0L) {
                entityObj.addNativeData("entity_byte_channel", (Object)new EntityWrapper(new EntityBodyChannel(httpMessageDataStreamer.getInputStream())));
            }
        }
    }

    public static void constructNonBlockingDataSource(final CompletableFuture<Object> balFuture, final BObject entity, final SourceType sourceType) {
        HttpCarbonMessage inboundMessage = ExternHttpDataSourceBuilder.extractTransportMessageFromEntity(entity);
        if (inboundMessage.isContentReleased()) {
            ExternHttpDataSourceBuilder.createErrorAndNotify(balFuture, "Entity body content is already released");
            return;
        }
        inboundMessage.getFullHttpCarbonMessage().addListener(new FullHttpMessageListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onComplete(HttpCarbonMessage inboundMessage) {
                Object dataSource = null;
                HttpMessageDataStreamer dataStreamer = new HttpMessageDataStreamer(inboundMessage);
                InputStream inputStream = dataStreamer.getInputStream();
                try {
                    switch (sourceType.ordinal()) {
                        case 0: {
                            dataSource = EntityBodyHandler.constructJsonDataSource((BObject)entity, (InputStream)inputStream);
                            ExternHttpDataSourceBuilder.updateJsonDataSourceAndNotify(balFuture, entity, dataSource);
                            return;
                        }
                        case 2: {
                            dataSource = EntityBodyHandler.constructStringDataSource((BObject)entity, (InputStream)inputStream);
                            break;
                        }
                        case 1: {
                            dataSource = EntityBodyHandler.constructXmlDataSource((BObject)entity, (InputStream)inputStream);
                            break;
                        }
                        case 3: {
                            dataSource = EntityBodyHandler.constructBlobDataSource((InputStream)inputStream);
                        }
                    }
                    ExternHttpDataSourceBuilder.updateDataSourceAndNotify(balFuture, entity, dataSource);
                }
                catch (Exception e) {
                    ExternHttpDataSourceBuilder.createErrorAndNotify(balFuture, "Error occurred while extracting " + sourceType.toString().toLowerCase(Locale.ENGLISH) + " data from entity: " + ExternHttpDataSourceBuilder.getErrorMsg((Throwable)e));
                }
                finally {
                    try {
                        inputStream.close();
                    }
                    catch (IOException exception) {
                        log.error("Error occurred while closing the inbound data stream", (Throwable)exception);
                    }
                }
            }

            @Override
            public void onError(Exception ex) {
                ExternHttpDataSourceBuilder.createErrorAndNotify(balFuture, "Error occurred while extracting content from message : " + ex.getMessage());
            }
        });
    }

    private static Object notifyError(Exception exception, String type) {
        return ExternHttpDataSourceBuilder.createError((Exception)exception, (String)type);
    }

    private static Object notifyError(CompletableFuture<Object> balFuture, Exception exception, String type) {
        BError error = (BError)((Object)ExternHttpDataSourceBuilder.createError((Exception)exception, (String)type));
        if (balFuture != null) {
            ExternHttpDataSourceBuilder.setReturnValuesAndNotify(balFuture, (Object)error);
            return null;
        }
        return error;
    }

    private static void createErrorAndNotify(CompletableFuture<Object> balFuture, String errMsg) {
        BError error = MimeUtil.createError((String)"ParserError", (String)errMsg);
        ExternHttpDataSourceBuilder.setReturnValuesAndNotify(balFuture, (Object)error);
    }

    private static void setReturnValuesAndNotify(CompletableFuture<Object> balFuture, Object result) {
        balFuture.complete(result);
    }

    private static void updateDataSourceAndNotify(CompletableFuture<Object> balFuture, BObject entityObj, Object result) {
        ExternHttpDataSourceBuilder.updateDataSource((BObject)entityObj, (Object)result);
        ExternHttpDataSourceBuilder.setReturnValuesAndNotify(balFuture, result);
    }

    private static void updateJsonDataSourceAndNotify(CompletableFuture<Object> balFuture, BObject entityObj, Object result) {
        ExternHttpDataSourceBuilder.updateJsonDataSource((BObject)entityObj, (Object)result);
        ExternHttpDataSourceBuilder.setReturnValuesAndNotify(balFuture, result);
    }

    private static HttpCarbonMessage extractTransportMessageFromEntity(BObject entityObj) {
        HttpCarbonMessage message = (HttpCarbonMessage)entityObj.getNativeData("transport_message");
        if (message != null) {
            return message;
        }
        throw MimeUtil.createError((String)"NoContentError", (String)"Empty content");
    }

    private ExternHttpDataSourceBuilder() {
    }

    public static enum SourceType {
        JSON,
        XML,
        TEXT,
        BLOB;

    }
}

