/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.ValueCreatorUtils;
import io.ballerina.stdlib.http.api.nativeimpl.ModuleUtils;
import io.ballerina.stdlib.mime.util.HeaderUtil;
import java.util.Map;

public class ParseHeader {
    private static final RecordType HEADER_VALUE_TYPE = ParseHeader.createHeaderValueType();
    private static final ArrayType ARRAY_TYPE = TypeCreator.createArrayType((Type)HEADER_VALUE_TYPE);
    private static final String COMMA_OUT_OF_QUOTATIONS = "(,)(?=(?:[^\"]|\"[^\"]*\")*$)";

    public static Object parseHeader(BString headerValue) {
        try {
            String[] headerValues = headerValue.getValue().split(COMMA_OUT_OF_QUOTATIONS);
            BArray recordArray = ValueCreator.createArrayValue((ArrayType)ARRAY_TYPE);
            for (int i = 0; i < headerValues.length; ++i) {
                String value = headerValues[i].trim();
                if (value.contains(";")) {
                    value = HeaderUtil.getHeaderValue((String)value);
                }
                BMap<BString, Object> record = ValueCreatorUtils.createHTTPRecordValue("HeaderValue");
                record.put((Object)HttpConstants.HEADER_VALUE_FIELD, (Object)StringUtils.fromString((String)value));
                record.put((Object)HttpConstants.HEADER_VALUE_PARAM_FIELD, (Object)HeaderUtil.getParamMap((String)headerValues[i]));
                recordArray.add((long)i, record);
            }
            return recordArray;
        }
        catch (Exception ex) {
            String errMsg = ex instanceof BError ? ex.toString() : ex.getMessage();
            return HttpUtil.createHttpError("failed to parse: " + errMsg, HttpErrorType.GENERIC_CLIENT_ERROR);
        }
    }

    private ParseHeader() {
    }

    private static RecordType createHeaderValueType() {
        return TypeCreator.createRecordType((String)"HeaderValue", (Module)ModuleUtils.getHttpPackage(), (long)0L, Map.of("value", TypeCreator.createField((Type)PredefinedTypes.TYPE_STRING, (String)"value", (long)0L), "params", TypeCreator.createField((Type)TypeCreator.createMapType((Type)PredefinedTypes.TYPE_STRING), (String)"params", (long)0L)), (Type)PredefinedTypes.TYPE_NEVER, (boolean)false, (int)0);
    }
}

