/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.endpoint;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HTTPServicesRegistry;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.endpoint.AbstractHttpNativeFunction;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class Register
extends AbstractHttpNativeFunction {
    public static Object register(Environment env, BObject serviceEndpoint, BObject service, Object serviceName) {
        try {
            HTTPServicesRegistry httpServicesRegistry = Register.getHttpServicesRegistry(serviceEndpoint);
            Runtime runtime = env.getRuntime();
            httpServicesRegistry.setRuntime(runtime);
            String basePath = Register.getBasePath(serviceName);
            httpServicesRegistry.registerService(service, basePath);
        }
        catch (BError ex) {
            return ex;
        }
        catch (Exception e) {
            return HttpUtil.createHttpError("service registration failed: " + e.getMessage(), HttpErrorType.GENERIC_LISTENER_ERROR);
        }
        return null;
    }

    private static String getBasePath(Object serviceName) {
        if (serviceName instanceof BArray) {
            List strings = Arrays.stream(((BArray)serviceName).getStringArray()).map(HttpUtil::unescapeAndEncodeValue).collect(Collectors.toList());
            String basePath = String.join((CharSequence)"/", strings);
            return HttpUtil.sanitizeBasePath(basePath);
        }
        if (serviceName instanceof BString) {
            String path = ((BString)serviceName).getValue().trim();
            if (path.startsWith("/")) {
                path = path.substring(1);
            }
            String[] pathSplits = path.split("/");
            List strings = Arrays.stream(pathSplits).map(HttpUtil::encodeString).collect(Collectors.toList());
            String basePath = String.join((CharSequence)"/", strings);
            return HttpUtil.sanitizeBasePath(basePath);
        }
        return "/";
    }

    private Register() {
    }
}

