/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.FunctionType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.NonRecurringParam;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import java.util.ArrayList;
import java.util.List;

public class RemoteMethodParamHandler {
    private final Type[] paramTypes;
    private final List<Parameter> otherParamList = new ArrayList<Parameter>();
    private static final String RES_TYPE = "http:Response";
    private static final String REQUEST_CONTEXT_TYPE = "http:RequestContext";
    private static final String REQ_TYPE = "http:Request";
    private static final String CALLER_TYPE = "http:Caller";

    public RemoteMethodParamHandler(RemoteMethodType remoteMethod) {
        this.paramTypes = HttpUtil.getParameterTypes((FunctionType)remoteMethod);
        this.validateSignatureParams();
    }

    private void validateSignatureParams() {
        block14: for (int index = 0; index < this.paramTypes.length; ++index) {
            String typeName;
            Type parameterType = this.paramTypes[index];
            switch (typeName = parameterType.toString()) {
                case "http:RequestContext": {
                    NonRecurringParam requestContextParam = new NonRecurringParam(index, "RequestContext");
                    this.getOtherParamList().add(requestContextParam);
                    continue block14;
                }
                case "http:Request": {
                    NonRecurringParam requestParam = new NonRecurringParam(index, "Request");
                    this.getOtherParamList().add(requestParam);
                    continue block14;
                }
                case "error": {
                    NonRecurringParam interceptorErrorParam = new NonRecurringParam(index, "error");
                    this.getOtherParamList().add(interceptorErrorParam);
                    continue block14;
                }
                case "http:Response": {
                    NonRecurringParam responseParam = new NonRecurringParam(index, "Response");
                    this.getOtherParamList().add(responseParam);
                    continue block14;
                }
                case "http:Caller": {
                    NonRecurringParam callerParam = new NonRecurringParam(index, "Caller");
                    this.getOtherParamList().add(callerParam);
                    continue block14;
                }
            }
        }
    }

    public int getParamCount() {
        return this.paramTypes.length;
    }

    public List<Parameter> getOtherParamList() {
        return this.otherParamList;
    }
}

