/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.util;

import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public class CacheUtils {
    public static final String WEAK_VALIDATOR_TAG = "W/";
    public static final String ETAG_HEADER = "ETag";
    public static final String IF_NONE_MATCH_HEADER = "If-None-Match";
    public static final String IF_MODIFIED_SINCE_HEADER = "If-Modified-Since";
    public static final String LAST_MODIFIED_HEADER = "Last-Modified";

    public static boolean isValidCachedResponse(HttpCarbonMessage outboundResponse, HttpCarbonMessage inboundRequest) {
        String outgoingETag = outboundResponse.getHeader(ETAG_HEADER);
        String incomingETags = inboundRequest.getHeader(IF_NONE_MATCH_HEADER);
        if (incomingETags != null) {
            if (outgoingETag == null) {
                return false;
            }
            return !CacheUtils.isNonMatchingETag(incomingETags, outgoingETag);
        }
        String ifModifiedSince = inboundRequest.getHeader(IF_MODIFIED_SINCE_HEADER);
        if (ifModifiedSince == null) {
            return false;
        }
        String lastModified = outboundResponse.getHeader(LAST_MODIFIED_HEADER);
        if (lastModified == null) {
            return false;
        }
        try {
            ZonedDateTime ifModifiedSinceTime = ZonedDateTime.parse(ifModifiedSince, DateTimeFormatter.RFC_1123_DATE_TIME);
            ZonedDateTime lastModifiedTime = ZonedDateTime.parse(lastModified, DateTimeFormatter.RFC_1123_DATE_TIME);
            return ((Object)ifModifiedSinceTime).equals(lastModifiedTime);
        }
        catch (DateTimeParseException e) {
            return false;
        }
    }

    private static boolean isNonMatchingETag(String etags, String outgoingETag) {
        String[] etagArray = etags.split(",");
        if (etagArray.length == 1 && "*".equals(etagArray[0])) {
            return false;
        }
        for (String etag : etagArray) {
            if (!CacheUtils.weakEquals(etag.trim(), outgoingETag)) continue;
            return false;
        }
        return true;
    }

    private static boolean weakEquals(String requestETag, String responseETag) {
        String requestTagPortion = CacheUtils.isWeakEntityTag(requestETag) ? requestETag.substring(WEAK_VALIDATOR_TAG.length()) : requestETag;
        String responseTagPortion = CacheUtils.isWeakEntityTag(responseETag) ? responseETag.substring(WEAK_VALIDATOR_TAG.length()) : responseETag;
        return requestTagPortion.equals(responseTagPortion);
    }

    private static boolean isWeakEntityTag(String etag) {
        return etag.startsWith(WEAK_VALIDATOR_TAG);
    }

    public static BString getProperty(BString name) {
        String value = System.getProperty(name.getValue());
        if (value == null) {
            return (BString)PredefinedTypes.TYPE_STRING.getZeroValue();
        }
        return StringUtils.fromString((String)value);
    }

    private CacheUtils() {
    }
}

