/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contract.config;

import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.InboundMsgSizeValidationConfig;
import io.ballerina.stdlib.http.transport.contract.config.KeepAliveConfig;
import io.ballerina.stdlib.http.transport.contract.config.Parameter;
import io.ballerina.stdlib.http.transport.contract.config.SslConfiguration;
import java.util.ArrayList;
import java.util.List;

public class ListenerConfiguration
extends SslConfiguration {
    public static final String DEFAULT_KEY = "default";
    private String id = "default";
    private String host = "0.0.0.0";
    private int port = 9090;
    private ChunkConfig chunkingConfig = ChunkConfig.AUTO;
    private KeepAliveConfig keepAliveConfig = KeepAliveConfig.AUTO;
    private boolean bindOnStartup = false;
    private String version = "1.1";
    private long socketIdleTimeout;
    private String messageProcessorId;
    private boolean httpTraceLogEnabled;
    private boolean httpAccessLogEnabled;
    private String serverHeader = "wso2-http-transport";
    private List<Parameter> parameters = this.getDefaultParameters();
    private InboundMsgSizeValidationConfig requestSizeValidationConfig = new InboundMsgSizeValidationConfig();
    private boolean pipeliningEnabled;
    private boolean webSocketCompressionEnabled;
    private long pipeliningLimit;
    private int gracefulStopTimeout = 0;
    private int soBackLog;
    private int connectTimeOut;
    private int receiveBufferSize;
    private int sendBufferSize;
    private boolean tcpNoDelay;
    private boolean socketReuse;
    private boolean socketKeepAlive;
    private int http2InitialWindowSize = 65535;
    private long minIdleTimeInStaleState = 3000000L;
    private long timeBetweenStaleEviction = 30000L;

    @Deprecated
    public static ListenerConfiguration getDefault() {
        ListenerConfiguration defaultConfig = new ListenerConfiguration(DEFAULT_KEY, "0.0.0.0", 8080);
        return defaultConfig;
    }

    public ListenerConfiguration() {
    }

    public ListenerConfiguration(String id, String host, int port) {
        this.id = id;
        this.host = host;
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public boolean isBindOnStartup() {
        return this.bindOnStartup;
    }

    public void setBindOnStartup(boolean bindOnStartup) {
        this.bindOnStartup = bindOnStartup;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public List<Parameter> getParameters() {
        return this.parameters;
    }

    private List<Parameter> getDefaultParameters() {
        return new ArrayList<Parameter>();
    }

    public long getSocketIdleTimeout() {
        return this.socketIdleTimeout;
    }

    public String getMessageProcessorId() {
        return this.messageProcessorId;
    }

    public void setMessageProcessorId(String messageProcessorId) {
        this.messageProcessorId = messageProcessorId;
    }

    public void setSocketIdleTimeout(int socketIdleTimeout) {
        this.socketIdleTimeout = socketIdleTimeout;
    }

    public boolean isHttpTraceLogEnabled() {
        return this.httpTraceLogEnabled;
    }

    public void setHttpTraceLogEnabled(boolean httpTraceLogEnabled) {
        this.httpTraceLogEnabled = httpTraceLogEnabled;
    }

    public boolean isHttpAccessLogEnabled() {
        return this.httpAccessLogEnabled;
    }

    public void setHttpAccessLogEnabled(boolean httpAccessLogEnabled) {
        this.httpAccessLogEnabled = httpAccessLogEnabled;
    }

    public InboundMsgSizeValidationConfig getMsgSizeValidationConfig() {
        return this.requestSizeValidationConfig;
    }

    public void setMsgSizeValidationConfig(InboundMsgSizeValidationConfig requestSizeValidationConfig) {
        this.requestSizeValidationConfig = requestSizeValidationConfig;
    }

    public ChunkConfig getChunkConfig() {
        return this.chunkingConfig;
    }

    public void setChunkConfig(ChunkConfig chunkConfig) {
        this.chunkingConfig = chunkConfig;
    }

    public KeepAliveConfig getKeepAliveConfig() {
        return this.keepAliveConfig;
    }

    public void setKeepAliveConfig(KeepAliveConfig keepAliveConfig) {
        this.keepAliveConfig = keepAliveConfig;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public boolean isPipeliningEnabled() {
        return this.pipeliningEnabled;
    }

    public void setPipeliningEnabled(boolean pipeliningEnabled) {
        this.pipeliningEnabled = pipeliningEnabled;
    }

    public long getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    public void setPipeliningLimit(long pipeliningLimit) {
        this.pipeliningLimit = pipeliningLimit;
    }

    public boolean isWebSocketCompressionEnabled() {
        return this.webSocketCompressionEnabled;
    }

    public void setWebSocketCompressionEnabled(boolean webSocketCompressionEnabled) {
        this.webSocketCompressionEnabled = webSocketCompressionEnabled;
    }

    public void setGracefulStopTimeout(int gracefulStopTimeout) {
        this.gracefulStopTimeout = gracefulStopTimeout;
    }

    public int getGracefulStopTimeout() {
        return this.gracefulStopTimeout;
    }

    public int getSoBackLog() {
        return this.soBackLog;
    }

    public void setSoBackLog(int soBackLog) {
        this.soBackLog = soBackLog;
    }

    public int getConnectTimeOut() {
        return this.connectTimeOut;
    }

    public void setConnectTimeOut(double connectTimeOut) {
        this.connectTimeOut = (int)(connectTimeOut * 1000.0);
    }

    public int getReceiveBufferSize() {
        return this.receiveBufferSize;
    }

    public void setReceiveBufferSize(int receiveBufferSize) {
        this.receiveBufferSize = receiveBufferSize;
    }

    public int getSendBufferSize() {
        return this.sendBufferSize;
    }

    public void setSendBufferSize(int sendBufferSize) {
        this.sendBufferSize = sendBufferSize;
    }

    public boolean isTcpNoDelay() {
        return this.tcpNoDelay;
    }

    public void setTcpNoDelay(boolean tcpNoDelay) {
        this.tcpNoDelay = tcpNoDelay;
    }

    public boolean isSocketReuse() {
        return this.socketReuse;
    }

    public void setSocketReuse(boolean socketReuse) {
        this.socketReuse = socketReuse;
    }

    public boolean isSocketKeepAlive() {
        return this.socketKeepAlive;
    }

    public void setSocketKeepAlive(boolean keepAlive) {
        this.socketKeepAlive = keepAlive;
    }

    public int getHttp2InitialWindowSize() {
        return this.http2InitialWindowSize;
    }

    public void setHttp2InitialWindowSize(int http2InitialWindowSize) {
        this.http2InitialWindowSize = http2InitialWindowSize;
    }

    public void setTimeBetweenStaleEviction(long timeBetweenStaleEviction) {
        this.timeBetweenStaleEviction = timeBetweenStaleEviction;
    }

    public void setMinIdleTimeInStaleState(long minIdleTimeInStaleState) {
        this.minIdleTimeInStaleState = minIdleTimeInStaleState;
    }

    public long getMinIdleTimeInStaleState() {
        return this.minIdleTimeInStaleState;
    }

    public long getTimeBetweenStaleEviction() {
        return this.timeBetweenStaleEviction;
    }
}

