/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contract.config;

import io.ballerina.stdlib.http.transport.contract.config.ListenerConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.TransportProperty;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

@XmlRootElement(name="transports")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class TransportsConfiguration {
    @XmlElementWrapper(name="properties")
    @XmlElement(name="property")
    private Set<TransportProperty> transportProperties = new HashSet<TransportProperty>();
    @XmlElementWrapper(name="listeners")
    @XmlElement(name="listener")
    private Set<ListenerConfiguration> listenerConfigurations;
    @XmlElementWrapper(name="senders")
    @XmlElement(name="sender")
    private Set<SenderConfiguration> senderConfigurations;

    @Deprecated
    public static TransportsConfiguration getDefault() {
        TransportsConfiguration defaultConfig = new TransportsConfiguration();
        ListenerConfiguration listenerConfiguration = ListenerConfiguration.getDefault();
        HashSet<ListenerConfiguration> listenerConfigurations = new HashSet<ListenerConfiguration>();
        listenerConfigurations.add(listenerConfiguration);
        defaultConfig.setListenerConfigurations(listenerConfigurations);
        SenderConfiguration senderConfiguration = SenderConfiguration.getDefault();
        HashSet<SenderConfiguration> senderConfigurations = new HashSet<SenderConfiguration>();
        senderConfigurations.add(senderConfiguration);
        defaultConfig.setSenderConfigurations(senderConfigurations);
        HashSet<TransportProperty> transportProperties = new HashSet<TransportProperty>();
        defaultConfig.setTransportProperties(transportProperties);
        return defaultConfig;
    }

    public TransportsConfiguration() {
        ListenerConfiguration listenerConfiguration = new ListenerConfiguration();
        this.listenerConfigurations = new HashSet<ListenerConfiguration>();
        this.listenerConfigurations.add(listenerConfiguration);
        SenderConfiguration senderConfiguration = new SenderConfiguration();
        this.senderConfigurations = new HashSet<SenderConfiguration>();
        this.senderConfigurations.add(senderConfiguration);
    }

    public Set<ListenerConfiguration> getListenerConfigurations() {
        if (this.listenerConfigurations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.listenerConfigurations);
    }

    public Set<SenderConfiguration> getSenderConfigurations() {
        if (this.senderConfigurations == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.senderConfigurations);
    }

    public void setListenerConfigurations(Set<ListenerConfiguration> listenerConfigurations) {
        this.listenerConfigurations = Collections.unmodifiableSet(listenerConfigurations);
    }

    public void setSenderConfigurations(Set<SenderConfiguration> senderConfigurations) {
        this.senderConfigurations = Collections.unmodifiableSet(senderConfigurations);
    }

    public Set<TransportProperty> getTransportProperties() {
        return this.transportProperties;
    }

    public void setTransportProperties(Set<TransportProperty> transportProperties) {
        this.transportProperties = transportProperties;
    }
}

