/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl;

import io.ballerina.stdlib.http.api.logging.accesslog.HttpAccessLogMessage;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.config.ChunkConfig;
import io.ballerina.stdlib.http.transport.contract.config.ForwardedExtensionConfig;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.exceptions.ClientConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.DefaultHttpResponseFuture;
import io.ballerina.stdlib.http.transport.contractimpl.common.HttpRoute;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.SenderReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.ConnectionAvailabilityListener;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.BootstrapConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.TargetChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientTimeoutHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.RequestWriteStarter;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.SendingHeaders;
import io.ballerina.stdlib.http.transport.message.ClientRemoteFlowControlListener;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.Http2Reset;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.ResponseHandle;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Calendar;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHttpClientConnector
implements HttpClientConnector {
    private static final Logger LOG = LoggerFactory.getLogger(HttpClientConnector.class);
    private ConnectionManager connectionManager;
    private Http2ConnectionManager http2ConnectionManager;
    private SenderConfiguration senderConfiguration;
    private SSLConfig sslConfig;
    private int socketIdleTimeout;
    private String httpVersion;
    private ChunkConfig chunkConfig;
    private boolean http2;
    private ForwardedExtensionConfig forwardedExtensionConfig;
    private EventLoopGroup clientEventGroup;
    private BootstrapConfiguration bootstrapConfig;
    private int configHashCode;

    public DefaultHttpClientConnector(ConnectionManager connectionManager, SenderConfiguration senderConfiguration, BootstrapConfiguration bootstrapConfig, EventLoopGroup clientEventGroup, int configHashCode) {
        this.connectionManager = connectionManager;
        this.http2ConnectionManager = connectionManager.getHttp2ConnectionManager();
        this.senderConfiguration = senderConfiguration;
        this.initTargetChannelProperties(senderConfiguration);
        if ("2.0".equals(senderConfiguration.getHttpVersion())) {
            this.http2 = true;
        }
        this.clientEventGroup = clientEventGroup;
        this.bootstrapConfig = bootstrapConfig;
        this.configHashCode = configHashCode;
    }

    @Override
    public HttpResponseFuture connect() {
        return null;
    }

    @Override
    public HttpResponseFuture getResponse(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public HttpResponseFuture getNextPushPromise(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public HttpResponseFuture hasPushPromise(ResponseHandle responseHandle) {
        return responseHandle.getOutboundMsgHolder().getResponseFuture();
    }

    @Override
    public void rejectPushResponse(Http2PushPromise pushPromise) {
        Http2Reset http2Reset = new Http2Reset(pushPromise.getPromisedStreamId());
        OutboundMsgHolder outboundMsgHolder = pushPromise.getOutboundMsgHolder();
        pushPromise.reject();
        outboundMsgHolder.getHttp2ClientChannel().getChannel().write((Object)http2Reset);
    }

    @Override
    public HttpResponseFuture getPushResponse(Http2PushPromise pushPromise) {
        OutboundMsgHolder outboundMsgHolder = pushPromise.getOutboundMsgHolder();
        if (pushPromise.isRejected()) {
            outboundMsgHolder.getResponseFuture().notifyPushResponse(pushPromise.getPromisedStreamId(), new ClientConnectorException("Cannot fetch a response for an rejected promise", HttpResponseStatus.BAD_REQUEST.code()));
        }
        return outboundMsgHolder.getResponseFuture();
    }

    @Override
    public boolean close() {
        return false;
    }

    @Override
    public HttpResponseFuture send(HttpCarbonMessage httpOutboundRequest) {
        OutboundMsgHolder outboundMsgHolder = new OutboundMsgHolder(httpOutboundRequest);
        return this.send(outboundMsgHolder, httpOutboundRequest);
    }

    public HttpResponseFuture send(final OutboundMsgHolder outboundMsgHolder, final HttpCarbonMessage httpOutboundRequest) {
        HttpResponseFuture httpResponseFuture;
        if (this.senderConfiguration.isHttpAccessLogEnabled()) {
            HttpAccessLogMessage outboundAccessLogMessage = new HttpAccessLogMessage();
            outboundAccessLogMessage.setDateTime(Calendar.getInstance());
            httpOutboundRequest.setProperty("OUTBOUND_ACCESS_LOG_MESSAGE", outboundAccessLogMessage);
        }
        Object sourceHandlerObject = httpOutboundRequest.getProperty("SRC_HANDLER");
        SourceHandler srcHandler = null;
        Http2SourceHandler http2SourceHandler = null;
        if (sourceHandlerObject != null) {
            if (sourceHandlerObject instanceof SourceHandler) {
                srcHandler = (SourceHandler)((Object)sourceHandlerObject);
            } else if (sourceHandlerObject instanceof Http2SourceHandler) {
                http2SourceHandler = (Http2SourceHandler)((Object)sourceHandlerObject);
            }
        }
        final SourceHandler http1xSrcHandler = srcHandler;
        final Http2SourceHandler http2SrcHandler = http2SourceHandler;
        if (srcHandler == null && http2SourceHandler == null && LOG.isDebugEnabled()) {
            LOG.debug("SRC_HANDLER property not found in the message. Message is not originated from the HTTP Server connector");
        }
        try {
            Http2ClientChannel activeHttp2ClientChannel;
            final HttpRoute route = this.getTargetRoute(this.senderConfiguration.getScheme(), httpOutboundRequest, this.configHashCode);
            if (this.http2 && (activeHttp2ClientChannel = this.http2ConnectionManager.fetchChannel(route)) != null) {
                outboundMsgHolder.setHttp2ClientChannel(activeHttp2ClientChannel);
                this.setHttp2ForwardedExtension(outboundMsgHolder);
                new RequestWriteStarter(outboundMsgHolder, activeHttp2ClientChannel).startWritingContent();
                httpResponseFuture = outboundMsgHolder.getResponseFuture();
                httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                return httpResponseFuture;
            }
            final TargetChannel targetChannel = this.connectionManager.borrowTargetChannel(route, srcHandler, http2SourceHandler, this.senderConfiguration, this.bootstrapConfig, this.clientEventGroup);
            final Http2ClientChannel freshHttp2ClientChannel = targetChannel.getHttp2ClientChannel();
            outboundMsgHolder.setHttp2ClientChannel(freshHttp2ClientChannel);
            httpResponseFuture = outboundMsgHolder.getResponseFuture();
            targetChannel.getConnectionReadyFuture().setListener(new ConnectionAvailabilityListener(){

                @Override
                public void onSuccess(String protocol, ChannelFuture channelFuture) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Created the connection to address: {}", (Object)(String.valueOf(route) + " Original Channel ID is : " + String.valueOf(channelFuture.channel().id())));
                    }
                    if (this.isH1c(protocol)) {
                        this.switchEventLoopForH1c(channelFuture).addListener(future -> this.startExecutingOutboundRequest(protocol, channelFuture));
                    } else if (this.isH2c(protocol)) {
                        this.switchEventLoopForH2c(channelFuture).addListener(future -> this.startExecutingOutboundRequest(protocol, channelFuture));
                    } else {
                        this.startExecutingOutboundRequest(protocol, channelFuture);
                    }
                }

                private void startExecutingOutboundRequest(String protocol, ChannelFuture channelFuture) {
                    if (protocol.equalsIgnoreCase("h2c") || protocol.equalsIgnoreCase("h2")) {
                        this.prepareTargetChannelForHttp2();
                    } else {
                        if (protocol.equalsIgnoreCase("h1")) {
                            DefaultHttpClientConnector.this.connectionManager.getHttp2ConnectionManager().releasePerRoutePoolLatch(targetChannel.getHttpRoute());
                            DefaultHttpClientConnector.this.http2 = false;
                        }
                        this.prepareTargetChannelForHttp(channelFuture);
                        if ((protocol.equalsIgnoreCase("h1c") || protocol.equalsIgnoreCase("h1")) && DefaultHttpClientConnector.this.senderConfiguration.getProxyServerConfiguration() != null) {
                            httpOutboundRequest.setProperty("IS_PROXY_ENABLED", true);
                        }
                        targetChannel.writeContent(httpOutboundRequest);
                    }
                }

                private void prepareTargetChannelForHttp2() {
                    freshHttp2ClientChannel.setSocketIdleTimeout(DefaultHttpClientConnector.this.socketIdleTimeout);
                    DefaultHttpClientConnector.this.connectionManager.getHttp2ConnectionManager().addHttp2ClientChannel(route, freshHttp2ClientChannel);
                    ((Http2RemoteFlowController)freshHttp2ClientChannel.getConnection().remote().flowController()).listener((Http2RemoteFlowController.Listener)new ClientRemoteFlowControlListener(freshHttp2ClientChannel));
                    freshHttp2ClientChannel.addDataEventListener("idleStateHandler", new Http2ClientTimeoutHandler(DefaultHttpClientConnector.this.socketIdleTimeout, freshHttp2ClientChannel));
                    DefaultHttpClientConnector.this.setHttp2ForwardedExtension(outboundMsgHolder);
                    new RequestWriteStarter(outboundMsgHolder, freshHttp2ClientChannel).startWritingContent();
                    httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                }

                private void prepareTargetChannelForHttp(ChannelFuture channelFuture) {
                    freshHttp2ClientChannel.putInFlightMessage(1, outboundMsgHolder);
                    httpResponseFuture.notifyResponseHandle(new ResponseHandle(outboundMsgHolder));
                    targetChannel.getHttp2ClientChannel().setSocketIdleTimeout(DefaultHttpClientConnector.this.socketIdleTimeout);
                    Channel targetNettyChannel = channelFuture.channel();
                    this.initializeSenderReqRespStateMgr(targetNettyChannel);
                    targetChannel.setChannel(targetNettyChannel);
                    targetChannel.configTargetHandler(httpOutboundRequest, httpResponseFuture);
                    httpResponseFuture.setBackPressureObservable(targetChannel.getBackPressureObservable());
                    Util.setCorrelationIdForLogging(targetNettyChannel.pipeline(), targetChannel.getCorrelatedSource());
                    Util.handleOutboundConnectionHeader(DefaultHttpClientConnector.this.senderConfiguration, httpOutboundRequest);
                    String localAddress = ((InetSocketAddress)targetNettyChannel.localAddress()).getAddress().getHostAddress();
                    Util.setForwardedExtension(DefaultHttpClientConnector.this.forwardedExtensionConfig, localAddress, httpOutboundRequest);
                }

                private void initializeSenderReqRespStateMgr(Channel targetNettyChannel) {
                    SenderReqRespStateManager senderReqRespStateManager = new SenderReqRespStateManager(targetNettyChannel, DefaultHttpClientConnector.this.socketIdleTimeout);
                    senderReqRespStateManager.state = new SendingHeaders(senderReqRespStateManager, targetChannel, DefaultHttpClientConnector.this.httpVersion, DefaultHttpClientConnector.this.chunkConfig, httpResponseFuture);
                    targetChannel.senderReqRespStateManager = senderReqRespStateManager;
                }

                private ChannelFuture switchEventLoopForH1c(ChannelFuture channelFuture) {
                    return channelFuture.channel().deregister().addListener(future -> http1xSrcHandler.getEventLoop().register(channelFuture.channel()));
                }

                private ChannelFuture switchEventLoopForH2c(ChannelFuture channelFuture) {
                    return channelFuture.channel().deregister().addListener(future -> http2SrcHandler.getChannelHandlerContext().channel().eventLoop().register(channelFuture.channel()));
                }

                private boolean isH1c(String protocol) {
                    return "http".equalsIgnoreCase(protocol) && http1xSrcHandler != null;
                }

                private boolean isH2c(String protocol) {
                    return "http".equalsIgnoreCase(protocol) && http2SrcHandler != null;
                }

                @Override
                public void onFailure(ClientConnectorException cause) {
                    httpResponseFuture.notifyHttpListener(cause);
                    httpOutboundRequest.setIoException(new IOException("Remote host closed the connection before initiating outbound request"));
                    DefaultHttpClientConnector.this.connectionManager.getHttp2ConnectionManager().releasePerRoutePoolLatch(route);
                }
            });
        }
        catch (NoSuchElementException failedCause) {
            if ("Timeout waiting for idle object".equals(failedCause.getMessage())) {
                failedCause = new NoSuchElementException("Could not obtain a connection within maximum wait time");
            }
            return this.notifyListenerAndGetErrorResponseFuture(failedCause);
        }
        catch (Exception failedCause) {
            return this.notifyListenerAndGetErrorResponseFuture(failedCause);
        }
        return httpResponseFuture;
    }

    private void setHttp2ForwardedExtension(OutboundMsgHolder outboundMsgHolder) {
        String localAddress = ((InetSocketAddress)outboundMsgHolder.getHttp2ClientChannel().getChannel().localAddress()).getAddress().getHostAddress();
        Util.setForwardedExtension(this.forwardedExtensionConfig, localAddress, outboundMsgHolder.getRequest());
    }

    private HttpResponseFuture notifyListenerAndGetErrorResponseFuture(Exception failedCause) {
        DefaultHttpResponseFuture errorResponseFuture = new DefaultHttpResponseFuture();
        errorResponseFuture.notifyHttpListener(failedCause);
        return errorResponseFuture;
    }

    private HttpRoute getTargetRoute(String scheme, HttpCarbonMessage httpCarbonMessage, int configHashCode) {
        String host = this.fetchHost(httpCarbonMessage);
        int port = this.fetchPort(httpCarbonMessage);
        return new HttpRoute(scheme, host, port, configHashCode);
    }

    private int fetchPort(HttpCarbonMessage httpCarbonMessage) {
        int port;
        Object intProperty = httpCarbonMessage.getProperty("port");
        if (intProperty instanceof Integer) {
            port = (Integer)intProperty;
        } else {
            port = this.sslConfig != null ? 443 : 80;
            httpCarbonMessage.setProperty("port", port);
            LOG.debug("Cannot find property PORT of type integer, hence using {}", (Object)port);
        }
        return port;
    }

    private String fetchHost(HttpCarbonMessage httpCarbonMessage) {
        String host;
        Object hostProperty = httpCarbonMessage.getProperty("host");
        if (hostProperty instanceof String) {
            host = (String)hostProperty;
        } else {
            host = "localhost";
            httpCarbonMessage.setProperty("host", "localhost");
            LOG.debug("Cannot find property HOST of type string, hence using localhost as the host");
        }
        return host;
    }

    private void initTargetChannelProperties(SenderConfiguration senderConfiguration) {
        this.httpVersion = senderConfiguration.getHttpVersion();
        this.chunkConfig = senderConfiguration.getChunkingConfig();
        this.socketIdleTimeout = senderConfiguration.getSocketIdleTimeout(300000);
        this.sslConfig = senderConfiguration.getClientSSLConfig();
        this.forwardedExtensionConfig = senderConfiguration.getForwardedExtensionConfig();
    }

    @Override
    public void initializeSSLContext() throws Exception {
        if (Objects.nonNull(this.sslConfig)) {
            this.sslConfig.initializeSSLContext(this.http2);
        }
    }
}

