/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.common;

import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MBeanRegistrar {
    private static final MBeanRegistrar ourInstance = new MBeanRegistrar();
    private static final Logger LOG = LoggerFactory.getLogger(MBeanRegistrar.class);

    public static MBeanRegistrar getInstance() {
        return ourInstance;
    }

    private MBeanRegistrar() {
    }

    public boolean registerMBean(Object mBeanInstance, String category, String id) {
        this.assertNull(mBeanInstance, "MBean instance is null");
        this.assertNull(category, "MBean instance category is null");
        this.assertNull(id, "MBean instance name is null");
        try {
            MBeanServer mBeanServer = ManagementFactory.getPlatformMBeanServer();
            ObjectName objectName = new ObjectName(this.getObjectName(category, id));
            Set<ObjectName> set = mBeanServer.queryNames(objectName, null);
            if (set != null && set.isEmpty()) {
                mBeanServer.registerMBean(mBeanInstance, objectName);
            } else {
                mBeanServer.unregisterMBean(objectName);
                mBeanServer.registerMBean(mBeanInstance, objectName);
            }
            return true;
        }
        catch (InstanceAlreadyExistsException | InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e) {
            LOG.warn("Error registering a MBean with name ' " + id + " ' and category name ' " + category + "' for JMX management", (Throwable)e);
            return false;
        }
    }

    private String getObjectName(String category, String id) {
        String jmxAgentName = System.getProperty("jmx.agent.name");
        if (jmxAgentName == null || jmxAgentName.isEmpty()) {
            jmxAgentName = "ballerina";
        }
        return jmxAgentName + ":Type=" + category + ",Name=" + id;
    }

    private void assertNull(Object object, String msg) {
        if (object == null) {
            MBeanRegistrar.handleException(msg);
        }
    }

    private static void handleException(String msg) {
        LOG.error(msg);
    }
}

