/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.Http2OutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.EntityBodyReceived;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ReceivingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.Response100ContinueSent;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Expect100ContinueHeaderReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(Expect100ContinueHeaderReceived.class);
    private final Http2MessageStateContext http2MessageStateContext;

    Expect100ContinueHeaderReceived(Http2MessageStateContext http2MessageStateContext) {
        this.http2MessageStateContext = http2MessageStateContext;
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) throws Http2Exception, ServerConnectorException {
        this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext));
        this.http2MessageStateContext.getListenerState().readInboundRequestBody(http2SourceHandler, dataFrame);
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (Util.getHttpResponseStatus(outboundResponseMsg).code() == HttpResponseStatus.CONTINUE.code()) {
            this.http2MessageStateContext.setListenerState(new Response100ContinueSent(this.http2MessageStateContext));
        } else {
            this.http2MessageStateContext.setListenerState(new EntityBodyReceived(this.http2MessageStateContext));
        }
        this.http2MessageStateContext.getListenerState().writeOutboundResponseBody(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) {
        LOG.warn("writeOutboundPromise {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        Http2StateUtil.sendRequestTimeoutResponse(ctx, http2OutboundRespListener, streamId, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER, true, true);
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Remote client closed the connection before initiating 100 continue response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
    }

    @Override
    public void handleClientGoAway(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext channelHandlerContext, Http2OutboundRespListener http2OutboundRespListener, Integer streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Remote client sent GOAWAY before initiating 100 continue response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
    }
}

