/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.http2;

import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.netty.channel.Channel;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class Http2ChannelPool {
    private static final Logger LOG = LoggerFactory.getLogger(Http2ChannelPool.class);
    private final Map<String, PerRouteConnectionPool> perRouteConnectionPools = new HashMap<String, PerRouteConnectionPool>();

    Http2ChannelPool() {
    }

    PerRouteConnectionPool fetchPerRoutePool(String key) {
        return this.perRouteConnectionPools.get(key);
    }

    Map<String, PerRouteConnectionPool> getPerRouteConnectionPools() {
        return this.perRouteConnectionPools;
    }

    static class PerRouteConnectionPool {
        private final BlockingQueue<Http2ClientChannel> http2ClientChannels = new LinkedBlockingQueue<Http2ClientChannel>();
        private final int maxActiveStreams;
        private CountDownLatch newChannelInitializerLatch = new CountDownLatch(1);
        private boolean newChannelInitializer = true;
        private final ReentrantLock lock = new ReentrantLock();

        PerRouteConnectionPool(int maxActiveStreams) {
            this.maxActiveStreams = maxActiveStreams;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Http2ClientChannel fetchTargetChannel() {
            this.waitTillNewChannelInitialized();
            if (!this.http2ClientChannels.isEmpty()) {
                Http2ClientChannel http2ClientChannel = (Http2ClientChannel)this.http2ClientChannels.peek();
                if (http2ClientChannel == null) {
                    return this.fetchTargetChannel();
                }
                Channel channel = http2ClientChannel.getChannel();
                if (channel == null) {
                    this.removeChannel(http2ClientChannel);
                    return this.fetchTargetChannel();
                }
                int activeStreamCount = http2ClientChannel.incrementActiveStreamCount();
                if (activeStreamCount < this.maxActiveStreams) {
                    return http2ClientChannel;
                }
                if (activeStreamCount == this.maxActiveStreams) {
                    http2ClientChannel.markAsExhausted();
                    this.removeChannel(http2ClientChannel);
                    if (this.http2ClientChannels.isEmpty()) {
                        this.lock.lock();
                        try {
                            this.newChannelInitializer = true;
                            this.newChannelInitializerLatch = new CountDownLatch(1);
                        }
                        finally {
                            this.lock.unlock();
                        }
                    }
                    return http2ClientChannel;
                }
                this.removeChannel(http2ClientChannel);
                return this.fetchTargetChannel();
            }
            return null;
        }

        void addChannel(Http2ClientChannel http2ClientChannel) {
            this.http2ClientChannels.add(http2ClientChannel);
            this.releaseCountdown();
        }

        void releaseCountdown() {
            this.lock.lock();
            try {
                this.newChannelInitializerLatch.countDown();
            }
            finally {
                this.lock.unlock();
            }
        }

        void removeChannel(Http2ClientChannel http2ClientChannel) {
            this.http2ClientChannels.remove(http2ClientChannel);
        }

        private void waitTillNewChannelInitialized() {
            try {
                if (this.newChannelInitializer) {
                    this.newChannelInitializer = false;
                } else {
                    this.newChannelInitializerLatch.await();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Interrupted before adding the target channel");
            }
        }
    }
}

