/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.http2;

import io.ballerina.stdlib.http.transport.contractimpl.common.HttpRoute;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.PoolConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ChannelPool;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Http2ConnectionManager {
    Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Http2ChannelPool http2ChannelPool = new Http2ChannelPool();
    private final BlockingQueue<Http2ClientChannel> http2StaleClientChannels = new LinkedBlockingQueue<Http2ClientChannel>();
    private final BlockingQueue<Http2ClientChannel> http2IdleClientChannels = new LinkedBlockingQueue<Http2ClientChannel>();
    private final PoolConfiguration poolConfiguration;
    private final ReentrantLock lock = new ReentrantLock();

    public Http2ConnectionManager(PoolConfiguration poolConfiguration) {
        this.poolConfiguration = poolConfiguration;
        this.initiateStaleConnectionEvictionTask();
        this.initiateIdleConnectionEvictionTask();
    }

    public void addHttp2ClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        String key = this.generateKey(httpRoute);
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = this.getOrCreatePerRoutePool(this.http2ChannelPool, key);
        perRouteConnectionPool.addChannel(http2ClientChannel);
        http2ClientChannel.getChannel().closeFuture().addListener(future -> {
            Http2ChannelPool.PerRouteConnectionPool pool = this.http2ChannelPool.fetchPerRoutePool(key);
            if (pool != null) {
                pool.removeChannel(http2ClientChannel);
                http2ClientChannel.getDataEventListeners().forEach(Http2DataEventListener::destroy);
            }
        });
    }

    public void releasePerRoutePoolLatch(HttpRoute httpRoute) {
        String key = this.generateKey(httpRoute);
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = this.http2ChannelPool.fetchPerRoutePool(key);
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.releaseCountdown();
        }
    }

    private Http2ChannelPool.PerRouteConnectionPool getOrCreatePerRoutePool(Http2ChannelPool pool, String key) {
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = pool.fetchPerRoutePool(key);
        if (perRouteConnectionPool != null) {
            return perRouteConnectionPool;
        }
        return this.createPerRouteConnectionPool(pool, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Http2ChannelPool.PerRouteConnectionPool createPerRouteConnectionPool(Http2ChannelPool pool, String key) {
        this.lock.lock();
        try {
            Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = pool.getPerRouteConnectionPools().get(key);
            if (perRouteConnectionPool == null) {
                perRouteConnectionPool = new Http2ChannelPool.PerRouteConnectionPool(this.poolConfiguration.getHttp2MaxActiveStreamsPerConnection());
                pool.getPerRouteConnectionPools().put(key, perRouteConnectionPool);
            }
            Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool2 = perRouteConnectionPool;
            return perRouteConnectionPool2;
        }
        finally {
            this.lock.unlock();
        }
    }

    public Http2ClientChannel fetchChannel(HttpRoute httpRoute) {
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = this.getOrCreatePerRoutePool(this.http2ChannelPool, this.generateKey(httpRoute));
        return perRouteConnectionPool.fetchTargetChannel();
    }

    void returnClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = this.fetchPerRoutePool(httpRoute);
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.addChannel(http2ClientChannel);
        }
    }

    void removeClientChannel(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = this.fetchPerRoutePool(httpRoute);
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.removeChannel(http2ClientChannel);
        }
    }

    void markClientChannelAsStale(HttpRoute httpRoute, Http2ClientChannel http2ClientChannel) {
        Http2ChannelPool.PerRouteConnectionPool perRouteConnectionPool = this.fetchPerRoutePool(httpRoute);
        if (perRouteConnectionPool != null) {
            perRouteConnectionPool.removeChannel(http2ClientChannel);
        }
        http2ClientChannel.setTimeSinceMarkedAsStale(System.currentTimeMillis());
        this.http2StaleClientChannels.add(http2ClientChannel);
    }

    void removeClosedChannelFromStalePool(Http2ClientChannel http2ClientChannel) {
        if (!this.http2StaleClientChannels.remove(http2ClientChannel)) {
            this.logger.warn("Specified channel does not exist in the stale list.");
        }
    }

    void removeClosedChannelFromIdlePool(Http2ClientChannel http2ClientChannel) {
        if (!this.http2IdleClientChannels.remove(http2ClientChannel)) {
            this.logger.warn("Specified channel does not exist in the HTTP2 client channel list.");
        }
    }

    void markClientChannelAsIdle(Http2ClientChannel http2ClientChannel) {
        http2ClientChannel.setTimeSinceMarkedAsIdle(System.currentTimeMillis());
        if (!this.http2IdleClientChannels.contains(http2ClientChannel)) {
            this.http2IdleClientChannels.add(http2ClientChannel);
        }
    }

    private void initiateStaleConnectionEvictionTask() {
        Timer timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Http2ConnectionManager.this.http2StaleClientChannels.forEach(http2ClientChannel -> {
                    if (Http2ConnectionManager.this.poolConfiguration.getMinIdleTimeInStaleState() == -1L) {
                        if (!http2ClientChannel.hasInFlightMessages()) {
                            Http2ConnectionManager.this.closeChannelAndEvict((Http2ClientChannel)http2ClientChannel, EvictionType.STALE);
                        }
                    } else if (System.currentTimeMillis() - http2ClientChannel.getTimeSinceMarkedAsStale() > Http2ConnectionManager.this.poolConfiguration.getMinIdleTimeInStaleState()) {
                        Http2ConnectionManager.closeInFlightRequests(http2ClientChannel);
                        Http2ConnectionManager.this.closeChannelAndEvict((Http2ClientChannel)http2ClientChannel, EvictionType.STALE);
                    }
                });
            }
        };
        timer.schedule(timerTask, this.poolConfiguration.getTimeBetweenStaleEviction(), this.poolConfiguration.getTimeBetweenStaleEviction());
    }

    private void initiateIdleConnectionEvictionTask() {
        Timer timer = new Timer(true);
        TimerTask timerTask = new TimerTask(){

            @Override
            public void run() {
                Http2ConnectionManager.this.http2IdleClientChannels.forEach(http2ClientChannel -> {
                    if (Http2ConnectionManager.this.poolConfiguration.getMinEvictableIdleTime() == -1L) {
                        if (!http2ClientChannel.hasInFlightMessages()) {
                            Http2ConnectionManager.this.closeChannelAndEvict((Http2ClientChannel)http2ClientChannel, EvictionType.IDLE);
                        }
                    } else if (System.currentTimeMillis() - http2ClientChannel.getTimeSinceMarkedAsIdle() > Http2ConnectionManager.this.poolConfiguration.getMinEvictableIdleTime()) {
                        Http2ConnectionManager.closeInFlightRequests(http2ClientChannel);
                        Http2ConnectionManager.this.removeClientChannel(http2ClientChannel.getHttpRoute(), (Http2ClientChannel)http2ClientChannel);
                        Http2ConnectionManager.this.closeChannelAndEvict((Http2ClientChannel)http2ClientChannel, EvictionType.IDLE);
                    }
                });
            }
        };
        timer.schedule(timerTask, this.poolConfiguration.getTimeBetweenEvictionRuns(), this.poolConfiguration.getTimeBetweenEvictionRuns());
    }

    private static void closeInFlightRequests(Http2ClientChannel http2ClientChannel) {
        http2ClientChannel.getInFlightMessages().forEach((streamId, outboundMsgHolder) -> {
            Http2MessageStateContext messageStateContext = outboundMsgHolder.getRequest().getHttp2MessageStateContext();
            if (messageStateContext != null) {
                messageStateContext.getSenderState().handleConnectionClose((OutboundMsgHolder)outboundMsgHolder);
            }
        });
    }

    private Http2ChannelPool.PerRouteConnectionPool fetchPerRoutePool(HttpRoute httpRoute) {
        String key = this.generateKey(httpRoute);
        return this.http2ChannelPool.fetchPerRoutePool(key);
    }

    private String generateKey(HttpRoute httpRoute) {
        return httpRoute.getScheme() + ":" + httpRoute.getHost() + ":" + httpRoute.getPort() + ":" + httpRoute.getConfigHash();
    }

    private void closeChannelAndEvict(Http2ClientChannel http2ClientChannel, EvictionType evictionType) {
        if (evictionType == EvictionType.STALE) {
            this.removeClosedChannelFromStalePool(http2ClientChannel);
        } else {
            this.removeClosedChannelFromIdlePool(http2ClientChannel);
        }
        http2ClientChannel.invalidate();
    }

    private static enum EvictionType {
        STALE,
        IDLE;

    }
}

