/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2;

import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientTimeoutHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.ReceivingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.ReceivingHeaders;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.SenderState;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.SendingEntityBody;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitingFor100Continue
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final Http2MessageStateContext http2MessageStateContext;
    private final Http2TargetHandler http2TargetHandler;
    private final Http2ClientChannel http2ClientChannel;
    private final Http2TargetHandler.Http2RequestWriter http2RequestWriter;
    private final HttpContent httpContent;
    private List<HttpContent> cachedContent = new ArrayList<HttpContent>();

    WaitingFor100Continue(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter, HttpContent httpContent, ChannelHandlerContext ctx, int streamId, Http2MessageStateContext http2MessageStateContext) {
        this.http2TargetHandler = http2TargetHandler;
        this.http2RequestWriter = http2RequestWriter;
        this.http2ClientChannel = http2TargetHandler.getHttp2ClientChannel();
        this.httpContent = httpContent;
        this.http2MessageStateContext = http2MessageStateContext;
        this.configTimeOut(ctx, streamId, true);
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) throws Http2Exception {
        LOG.warn("writeOutboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        this.cachedContent.add(httpContent);
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        this.configTimeOut(ctx, http2HeadersFrame.getStreamId(), false);
        Http2Headers http2Headers = http2HeadersFrame.getHeaders();
        if (HttpResponseStatus.CONTINUE.codeAsText().contentEquals(http2Headers.status())) {
            http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
            http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, this.httpContent, http2MessageStateContext);
            for (HttpContent cachedHttpContent : this.cachedContent) {
                http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, cachedHttpContent, http2MessageStateContext);
            }
        } else {
            for (HttpContent cachedHttpContent : this.cachedContent) {
                cachedHttpContent.release();
            }
            http2MessageStateContext.setSenderState(new ReceivingHeaders(this.http2TargetHandler, this.http2RequestWriter));
            http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
        }
    }

    private void configTimeOut(ChannelHandlerContext ctx, int streamId, boolean expectContinue) {
        List<Http2DataEventListener> eventListeners = this.http2ClientChannel.getDataEventListeners();
        Http2ClientTimeoutHandler timeoutHandler = (Http2ClientTimeoutHandler)eventListeners.get(0);
        ScheduledFuture<?> timerTask = timeoutHandler.getTimerTasks().get(streamId);
        if (timerTask != null) {
            timerTask.cancel(true);
        }
        if (expectContinue) {
            timeoutHandler.createTimerTask(ctx, streamId, this.http2ClientChannel.getSocketIdleTimeout() / 5, true);
        } else {
            timeoutHandler.createTimerTask(ctx, streamId, this.http2ClientChannel.getSocketIdleTimeout(), false);
        }
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        http2MessageStateContext.setSenderState(new ReceivingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseBody(ctx, http2DataFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundPromise(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        LOG.warn("readInboundPromise is not a dependant action of this state");
    }

    @Override
    public void handleStreamTimeout(OutboundMsgHolder outboundMsgHolder, boolean serverPush, ChannelHandlerContext context, int streamId) throws Http2Exception {
        this.configTimeOut(context, streamId, false);
        this.http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
        this.http2MessageStateContext.getSenderState().writeOutboundRequestBody(context, this.httpContent, this.http2MessageStateContext);
        for (HttpContent cachedHttpContent : this.cachedContent) {
            this.http2MessageStateContext.getSenderState().writeOutboundRequestBody(context, cachedHttpContent, this.http2MessageStateContext);
        }
    }

    @Override
    public void handleConnectionClose(OutboundMsgHolder outboundMsgHolder) {
        StateUtil.handleIncompleteInboundMessage(outboundMsgHolder.getResponse(), "Remote host closed the connection while reading inbound response headers");
    }

    @Override
    public void handleServerGoAway(OutboundMsgHolder outboundMsgHolder) {
        outboundMsgHolder.getResponseFuture().notifyHttpListener(new ServerConnectorException("Remote host sent GOAWAY while reading inbound response headers"));
    }

    @Override
    public void handleRstStream(OutboundMsgHolder outboundMsgHolder) {
        outboundMsgHolder.getResponseFuture().notifyHttpListener(new ServerConnectorException("Remote host sent RST_STREAM while reading inbound response headers"));
    }
}

