/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.handler.codec.http2.Http2Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClientRemoteFlowControlListener
implements Http2RemoteFlowController.Listener {
    private static final Logger LOG = LoggerFactory.getLogger(ClientRemoteFlowControlListener.class);
    private Http2ClientChannel http2ClientChannel;
    private Http2RemoteFlowController http2RemoteFlowController;

    public ClientRemoteFlowControlListener(Http2ClientChannel http2ClientChannel) {
        this.http2ClientChannel = http2ClientChannel;
        this.http2RemoteFlowController = (Http2RemoteFlowController)http2ClientChannel.getConnection().remote().flowController();
    }

    public void writabilityChanged(Http2Stream stream) {
        OutboundMsgHolder outboundMsgHolder = this.http2ClientChannel.getInFlightMessage(stream.id());
        if (outboundMsgHolder == null) {
            return;
        }
        if (this.http2RemoteFlowController.isWritable(stream)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("In thread {}. Stream {} is writable. State {} ", new Object[]{Thread.currentThread().getName(), stream.id(), stream.state()});
            }
            outboundMsgHolder.setStreamWritable(true);
            outboundMsgHolder.getBackPressureObservable().notifyWritable();
        } else {
            if (LOG.isDebugEnabled()) {
                LOG.debug("In thread {}. Stream {} is not writable. State {} ", new Object[]{Thread.currentThread().getName(), stream.id(), stream.state()});
            }
            outboundMsgHolder.setStreamWritable(false);
        }
    }
}

