/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.message;

import io.ballerina.stdlib.http.transport.message.FullHttpMessageFuture;
import io.ballerina.stdlib.http.transport.message.FullHttpMessageListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;

public class DefaultFullHttpMessageFuture
implements FullHttpMessageFuture {
    private final HttpCarbonMessage httpCarbonMessage;
    private FullHttpMessageListener messageListener;
    private Exception error;

    DefaultFullHttpMessageFuture(HttpCarbonMessage httpCarbonMessage) {
        this.httpCarbonMessage = httpCarbonMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addListener(FullHttpMessageListener messageListener) {
        HttpCarbonMessage httpCarbonMessage = this.httpCarbonMessage;
        synchronized (httpCarbonMessage) {
            this.messageListener = messageListener;
            if (this.httpCarbonMessage.isLastHttpContentArrived()) {
                this.notifySuccess();
            } else if (this.error != null) {
                this.notifyFailure(this.error);
            }
        }
    }

    @Override
    public synchronized void removeListener() {
        this.messageListener = null;
    }

    @Override
    public void notifySuccess() {
        if (this.messageListener != null) {
            FullHttpMessageListener tempListener = this.messageListener;
            this.removeListener();
            tempListener.onComplete(this.httpCarbonMessage);
        }
    }

    @Override
    public void notifyFailure(Exception error) {
        this.error = error;
        if (this.messageListener != null) {
            FullHttpMessageListener tempListener = this.messageListener;
            this.removeListener();
            tempListener.onError(error);
            this.error = null;
        }
    }
}

