/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri;

import io.ballerina.stdlib.http.api.HttpResource;
import io.ballerina.stdlib.http.api.HttpService;
import io.ballerina.stdlib.http.api.InterceptorResource;
import io.ballerina.stdlib.http.api.InterceptorService;
import io.ballerina.stdlib.http.api.Resource;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public final class DispatcherUtil {
    private static String[] allMethods = new String[]{"GET", "HEAD", "POST", "DELETE", "PATCH", "PUT", "OPTIONS"};

    private DispatcherUtil() {
    }

    public static boolean isMatchingMethodExist(Resource resourceInfo, String method) {
        if (resourceInfo.getMethods() == null) {
            return false;
        }
        return resourceInfo.getMethods().contains(method);
    }

    public static String concatValues(List<String> stringValues, boolean spaceSeparated) {
        StringBuilder builder = new StringBuilder();
        String separator = spaceSeparated ? " " : ", ";
        for (int x = 0; x < stringValues.size(); ++x) {
            builder.append(stringValues.get(x));
            if (x == stringValues.size() - 1) continue;
            builder.append(separator);
        }
        return builder.toString();
    }

    public static List<String> validateAllowMethods(List<String> cachedMethods) {
        if (cachedMethods.isEmpty()) {
            return cachedMethods;
        }
        cachedMethods.add("OPTIONS");
        cachedMethods = cachedMethods.stream().distinct().collect(Collectors.toList());
        return cachedMethods;
    }

    public static List<String> addAllMethods() {
        return Arrays.stream(allMethods).collect(Collectors.toList());
    }

    public static List<String> getAllResourceMethods(HttpService service) {
        ArrayList<String> cachedMethods = new ArrayList<String>();
        for (HttpResource resource : service.getResources()) {
            if (resource.getMethods() == null) {
                cachedMethods.addAll(DispatcherUtil.addAllMethods());
                break;
            }
            cachedMethods.addAll(resource.getMethods());
        }
        return DispatcherUtil.validateAllowMethods(cachedMethods);
    }

    public static List<String> getInterceptorResourceMethods(InterceptorService httpInterceptorService) {
        ArrayList<String> cachedMethods = new ArrayList<String>();
        InterceptorResource resource = httpInterceptorService.getResource();
        if (resource.getMethods() == null) {
            cachedMethods.addAll(DispatcherUtil.addAllMethods());
        } else {
            cachedMethods.addAll(resource.getMethods());
        }
        return DispatcherUtil.validateAllowMethods(cachedMethods);
    }
}

