/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell;

import io.ballerina.projects.PackageCompilation;
import io.ballerina.shell.DiagnosticReporter;
import io.ballerina.shell.NotebookReturnValue;
import io.ballerina.shell.ShellCompilation;
import io.ballerina.shell.ShellReturnValue;
import io.ballerina.shell.exceptions.BallerinaShellException;
import io.ballerina.shell.invoker.AvailableVariable;
import io.ballerina.shell.invoker.ShellSnippetsInvoker;
import io.ballerina.shell.parser.TreeParser;
import io.ballerina.shell.preprocessor.Preprocessor;
import io.ballerina.shell.snippet.factory.SnippetFactory;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Optional;

public abstract class Evaluator
extends DiagnosticReporter {
    protected final Preprocessor preprocessor;
    protected final TreeParser treeParser;
    protected final SnippetFactory snippetFactory;
    protected final ShellSnippetsInvoker invoker;

    protected Evaluator(Preprocessor preprocessor, TreeParser treeParser, SnippetFactory snippetFactory, ShellSnippetsInvoker invoker) {
        this.preprocessor = preprocessor;
        this.treeParser = treeParser;
        this.snippetFactory = snippetFactory;
        this.invoker = invoker;
    }

    public abstract void initialize() throws BallerinaShellException;

    public abstract String evaluate(String var1) throws BallerinaShellException;

    public abstract ShellCompilation getCompilation(String var1);

    public abstract Optional<ShellReturnValue> getValue(Optional<PackageCompilation> var1) throws BallerinaShellException;

    public abstract Optional<NotebookReturnValue> getValueAsObject(Optional<PackageCompilation> var1) throws BallerinaShellException;

    public abstract String getBufferFileUri() throws IOException;

    public abstract void evaluateDeclarationFile(String var1) throws BallerinaShellException;

    public abstract void delete(Collection<String> var1) throws BallerinaShellException;

    public abstract void reset();

    public List<String> availableImports() {
        return this.invoker.availableImports();
    }

    public List<String> availableVariables() {
        return this.invoker.availableVariables();
    }

    public List<AvailableVariable> availableVariablesAsObjects() {
        return this.invoker.availableVariablesAsObjects();
    }

    public List<String> availableModuleDeclarations() {
        return this.invoker.availableModuleDeclarations();
    }

    public List<String> newVariableNames() {
        return this.invoker.newVariableNames();
    }

    public List<String> newModuleDeclarations() {
        return this.invoker.newModuleDeclarations();
    }

    public void clearPreviousVariablesAndModuleDclnsNames() {
        this.invoker.clearPreviousVariablesAndModuleDclnsNames();
    }

    public Preprocessor getPreprocessor() {
        return this.preprocessor;
    }

    public TreeParser getTreeParser() {
        return this.treeParser;
    }

    public SnippetFactory getSnippetFactory() {
        return this.snippetFactory;
    }

    public ShellSnippetsInvoker getInvoker() {
        return this.invoker;
    }
}

