/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.shell.Evaluator;
import io.ballerina.shell.ExceptionStatus;
import io.ballerina.shell.NotebookReturnValue;
import io.ballerina.shell.ShellCompilation;
import io.ballerina.shell.ShellReturnValue;
import io.ballerina.shell.exceptions.BallerinaShellException;
import io.ballerina.shell.exceptions.InvokerException;
import io.ballerina.shell.exceptions.InvokerPanicException;
import io.ballerina.shell.exceptions.PreprocessorException;
import io.ballerina.shell.exceptions.SnippetException;
import io.ballerina.shell.exceptions.TreeParserException;
import io.ballerina.shell.invoker.ShellSnippetsInvoker;
import io.ballerina.shell.parser.TreeParser;
import io.ballerina.shell.preprocessor.Preprocessor;
import io.ballerina.shell.snippet.Snippet;
import io.ballerina.shell.snippet.factory.SnippetFactory;
import io.ballerina.shell.utils.StringUtils;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Collection;
import java.util.HashSet;
import java.util.Optional;

public class EvaluatorImpl
extends Evaluator {
    protected EvaluatorImpl(Preprocessor preprocessor, TreeParser treeParser, SnippetFactory snippetFactory, ShellSnippetsInvoker invoker) {
        super(preprocessor, treeParser, snippetFactory, invoker);
    }

    @Override
    public void initialize() throws BallerinaShellException {
        try {
            this.invoker.initialize();
        }
        catch (BallerinaShellException e) {
            this.addAllDiagnostics(this.invoker.diagnostics());
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String evaluate(String source) throws BallerinaShellException {
        try {
            Collection<Node> nodes = this.treeParser.parseString(source);
            Collection<Snippet> snippets = this.snippetFactory.createSnippets(nodes);
            Optional<PackageCompilation> compilation = Optional.ofNullable(this.invoker.getCompilation(snippets));
            Optional<Object> invokerOut = this.invoker.execute(compilation);
            String string = invokerOut.map(StringUtils::getExpressionStringValue).orElse(null);
            return string;
        }
        finally {
            this.addAllDiagnostics(this.treeParser.diagnostics());
            this.addAllDiagnostics(this.snippetFactory.diagnostics());
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.treeParser.resetDiagnostics();
            this.snippetFactory.resetDiagnostics();
            this.invoker.resetDiagnostics();
        }
    }

    @Override
    public ShellCompilation getCompilation(String source) {
        try {
            Collection<Node> nodes = this.treeParser.parseString(source);
            Collection<Snippet> snippets = this.snippetFactory.createSnippets(nodes);
            PackageCompilation compilation = this.invoker.getCompilation(snippets);
            ExceptionStatus exceptionStatus = ExceptionStatus.SUCCESS;
            this.clearDiagnostics(exceptionStatus);
            return new ShellCompilation(compilation, exceptionStatus);
        }
        catch (TreeParserException e) {
            ExceptionStatus exceptionStatus = ExceptionStatus.TREE_PARSER_FAILED;
            this.clearDiagnostics(exceptionStatus);
            return new ShellCompilation(exceptionStatus);
        }
        catch (SnippetException e) {
            ExceptionStatus exceptionStatus = ExceptionStatus.SNIPPET_FAILED;
            this.clearDiagnostics(exceptionStatus);
            return new ShellCompilation(exceptionStatus);
        }
        catch (InvokerException e) {
            ExceptionStatus exceptionStatus = ExceptionStatus.INVOKER_FAILED;
            this.clearDiagnostics(exceptionStatus);
            return new ShellCompilation(exceptionStatus);
        }
    }

    @Override
    public Optional<ShellReturnValue> getValue(Optional<PackageCompilation> compilation) throws BallerinaShellException {
        try {
            Optional<Object> invokerOut = this.invoker.execute(compilation);
            String result = invokerOut.map(StringUtils::getExpressionStringValue).orElse(null);
            ExceptionStatus exceptionStatus = ExceptionStatus.SUCCESS;
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
            return Optional.of(new ShellReturnValue(result, exceptionStatus));
        }
        catch (InvokerPanicException e) {
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
            throw e;
        }
        catch (InvokerException e) {
            ExceptionStatus exceptionStatus = ExceptionStatus.INVOKER_FAILED;
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
            return Optional.of(new ShellReturnValue(exceptionStatus));
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public Optional<NotebookReturnValue> getValueAsObject(Optional<PackageCompilation> compilation) throws BallerinaShellException {
        try {
            Optional<Object> invokerOut = this.invoker.execute(compilation);
            Object result = invokerOut.orElse(null);
            ExceptionStatus exceptionStatus = ExceptionStatus.SUCCESS;
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
            return Optional.of(new NotebookReturnValue(result, exceptionStatus));
        }
        catch (InvokerPanicException e) {
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
            throw e;
        }
        catch (InvokerException e) {
            ExceptionStatus exceptionStatus = ExceptionStatus.INVOKER_FAILED;
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
            return Optional.of(new NotebookReturnValue(exceptionStatus));
        }
        catch (Exception e) {
            throw e;
        }
    }

    @Override
    public String getBufferFileUri() throws IOException {
        return this.invoker.getBufferFile().getAbsolutePath();
    }

    @Override
    public void evaluateDeclarationFile(String filePath) throws BallerinaShellException {
        try {
            String statements = Files.readString(Path.of(filePath, new String[0]), Charset.defaultCharset());
            Collection<Node> nodes = this.treeParser.parseDeclarations(statements);
            Collection<Snippet> snippets = this.snippetFactory.createSnippets(nodes);
            this.getValue(Optional.ofNullable(this.invoker.getCompilation(snippets)));
        }
        catch (IOException e) {
            this.addErrorDiagnostic("Failed to load declarations from file: " + filePath);
            throw new PreprocessorException();
        }
        finally {
            this.addAllDiagnostics(this.preprocessor.diagnostics());
            this.addAllDiagnostics(this.treeParser.diagnostics());
            this.addAllDiagnostics(this.snippetFactory.diagnostics());
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.preprocessor.resetDiagnostics();
            this.treeParser.resetDiagnostics();
            this.snippetFactory.resetDiagnostics();
            this.invoker.resetDiagnostics();
        }
    }

    @Override
    public void delete(Collection<String> declarationNames) throws BallerinaShellException {
        try {
            this.invoker.delete(new HashSet<String>(declarationNames));
        }
        finally {
            this.addAllDiagnostics(this.invoker.diagnostics());
            this.invoker.resetDiagnostics();
        }
    }

    @Override
    public void reset() {
        this.preprocessor.resetDiagnostics();
        this.treeParser.resetDiagnostics();
        this.snippetFactory.resetDiagnostics();
        this.invoker.resetDiagnostics();
        this.resetDiagnostics();
        this.invoker.reset();
    }

    private void clearDiagnostics(ExceptionStatus exceptionStatus) {
        switch (exceptionStatus) {
            case TREE_PARSER_FAILED: {
                this.addAllDiagnostics(this.treeParser.diagnostics());
                this.treeParser.resetDiagnostics();
                break;
            }
            case SNIPPET_FAILED: {
                this.addAllDiagnostics(this.treeParser.diagnostics());
                this.addAllDiagnostics(this.snippetFactory.diagnostics());
                this.snippetFactory.resetDiagnostics();
                this.treeParser.resetDiagnostics();
                break;
            }
            default: {
                this.addAllDiagnostics(this.treeParser.diagnostics());
                this.addAllDiagnostics(this.snippetFactory.diagnostics());
                this.addAllDiagnostics(this.invoker.diagnostics());
                this.snippetFactory.resetDiagnostics();
                this.treeParser.resetDiagnostics();
                this.invoker.resetDiagnostics();
            }
        }
    }
}

