/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker.classload;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ConstantDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.JBallerinaBackend;
import io.ballerina.projects.JvmTarget;
import io.ballerina.projects.ModuleId;
import io.ballerina.projects.PackageCompilation;
import io.ballerina.projects.Project;
import io.ballerina.shell.exceptions.InvokerException;
import io.ballerina.shell.invoker.AvailableVariable;
import io.ballerina.shell.invoker.ShellSnippetsInvoker;
import io.ballerina.shell.invoker.classload.GlobalVariable;
import io.ballerina.shell.invoker.classload.GlobalVariableSymbol;
import io.ballerina.shell.invoker.classload.ImportsManager;
import io.ballerina.shell.invoker.classload.context.ClassLoadContext;
import io.ballerina.shell.invoker.classload.context.StatementContext;
import io.ballerina.shell.invoker.classload.context.VariableContext;
import io.ballerina.shell.rt.InvokerMemory;
import io.ballerina.shell.snippet.Snippet;
import io.ballerina.shell.snippet.types.ExecutableSnippet;
import io.ballerina.shell.snippet.types.ImportDeclarationSnippet;
import io.ballerina.shell.snippet.types.ModuleMemberDeclarationSnippet;
import io.ballerina.shell.snippet.types.StatementSnippet;
import io.ballerina.shell.snippet.types.VariableDeclarationSnippet;
import io.ballerina.shell.utils.Identifier;
import io.ballerina.shell.utils.QuotedImport;
import io.ballerina.shell.utils.StringUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;

public class ClassLoadInvoker
extends ShellSnippetsInvoker {
    public static final String CONTEXT_EXPR_VAR_NAME = "__last__";
    private static final String DECLARATION_TEMPLATE_FILE = "template.declaration.mustache";
    private static final String EXECUTION_TEMPLATE_FILE = "template.execution.mustache";
    private final Set<Identifier> initialIdentifiers;
    private final ImportsManager importsManager;
    private final Map<Identifier, String> moduleDclns;
    private final Map<Identifier, GlobalVariable> globalVars;
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private final String contextId = UUID.randomUUID().toString();
    private final Map<Identifier, Set<Identifier>> newImports;
    private TypeSymbol anyTypeSymbol;
    private boolean noModuleDeclarations;
    private boolean noVariableDeclarations;
    private boolean noExecutables;
    private Map<VariableDeclarationSnippet, Set<Identifier>> variableDeclarations;
    private Map<Identifier, ModuleMemberDeclarationSnippet> moduleDeclarations;
    private final Map<Identifier, ModuleMemberDeclarationSnippet> availableModuleDeclarations;
    private List<ExecutableSnippet> executableSnippets;
    private List<Identifier> variableNames;
    private Project project;
    private final List<String> newDefinedVariableNames;
    private final List<String> newModuleDeclnNames;

    public ClassLoadInvoker() {
        this.moduleDclns = new HashMap<Identifier, String>();
        this.globalVars = new HashMap<Identifier, GlobalVariable>();
        this.newImports = new HashMap<Identifier, Set<Identifier>>();
        this.initialIdentifiers = new HashSet<Identifier>();
        this.importsManager = new ImportsManager();
        this.newDefinedVariableNames = new ArrayList<String>();
        this.newModuleDeclnNames = new ArrayList<String>();
        this.availableModuleDeclarations = new HashMap<Identifier, ModuleMemberDeclarationSnippet>();
    }

    @Override
    public void initialize() throws InvokerException {
        ClassLoadContext emptyContext = new ClassLoadContext(this.contextId, this.importsManager.getUsedImports(List.of()));
        Project project = this.getProject(emptyContext, DECLARATION_TEMPLATE_FILE);
        PackageCompilation compilation = this.compile(project);
        Identifier runFunctionName = new Identifier("__run");
        for (GlobalVariableSymbol symbol : this.globalVariableSymbols(project, compilation)) {
            this.initialIdentifiers.add(symbol.getName());
            if (!symbol.getName().equals(runFunctionName)) continue;
            assert (symbol.getTypeSymbol() instanceof FunctionTypeSymbol);
            FunctionTypeSymbol runFunctionType = (FunctionTypeSymbol)symbol.getTypeSymbol();
            this.anyTypeSymbol = (TypeSymbol)runFunctionType.returnTypeDescriptor().orElseThrow();
        }
        JBallerinaBackend.from((PackageCompilation)compilation, (JvmTarget)JvmTarget.JAVA_21);
        this.initialized.set(true);
        this.addDebugDiagnostic("Added initial identifiers: " + String.valueOf(this.initialIdentifiers));
    }

    @Override
    public void reset() {
        this.moduleDclns.clear();
        this.globalVars.clear();
        InvokerMemory.forgetAll((String)this.contextId);
        this.initialIdentifiers.clear();
        this.initialized.set(false);
        this.importsManager.reset();
        this.availableModuleDeclarations.clear();
    }

    @Override
    public PackageCompilation getCompilation(Collection<Snippet> newSnippets) throws InvokerException {
        if (!this.initialized.get()) {
            throw new IllegalStateException("Invoker execution not initialized.");
        }
        this.newImports.clear();
        this.clearPreviousVariablesAndModuleDclnsNames();
        this.variableDeclarations = new HashMap<VariableDeclarationSnippet, Set<Identifier>>();
        this.moduleDeclarations = new HashMap<Identifier, ModuleMemberDeclarationSnippet>();
        this.executableSnippets = new ArrayList<ExecutableSnippet>();
        this.variableNames = new ArrayList<Identifier>();
        for (Snippet newSnippet : newSnippets) {
            if (newSnippet instanceof ImportDeclarationSnippet) {
                ImportDeclarationSnippet importSnippet = (ImportDeclarationSnippet)newSnippet;
                this.processImport(importSnippet);
                continue;
            }
            if (newSnippet instanceof VariableDeclarationSnippet) {
                VariableDeclarationSnippet varDclnSnippet = (VariableDeclarationSnippet)newSnippet;
                this.variableNames.addAll(varDclnSnippet.names());
                this.variableDeclarations.put(varDclnSnippet, varDclnSnippet.names());
                continue;
            }
            if (newSnippet instanceof ModuleMemberDeclarationSnippet) {
                ModuleMemberDeclarationSnippet moduleDclnSnippet = (ModuleMemberDeclarationSnippet)newSnippet;
                Identifier moduleDeclarationName = moduleDclnSnippet.name();
                this.moduleDeclarations.put(moduleDeclarationName, moduleDclnSnippet);
                this.availableModuleDeclarations.put(moduleDeclarationName, moduleDclnSnippet);
                Set usedPrefixes = newSnippet.usedImports().stream().map(Identifier::new).collect(Collectors.toSet());
                this.newImports.put(moduleDeclarationName, usedPrefixes);
                continue;
            }
            if (newSnippet instanceof ExecutableSnippet) {
                ExecutableSnippet executableSnippet = (ExecutableSnippet)newSnippet;
                this.executableSnippets.add(executableSnippet);
                continue;
            }
            throw new UnsupportedOperationException("Unimplemented snippet category.");
        }
        this.noModuleDeclarations = this.moduleDeclarations.isEmpty();
        this.noVariableDeclarations = this.variableDeclarations.isEmpty();
        this.noExecutables = this.executableSnippets.isEmpty();
        PackageCompilation compilation = null;
        if (!(this.noModuleDeclarations && this.noVariableDeclarations && this.noExecutables)) {
            if (this.noModuleDeclarations && this.noVariableDeclarations) {
                ClassLoadContext execContext = this.createVariablesExecutionContext(List.of(), this.executableSnippets, Map.of());
                Project project = this.getProject(execContext, EXECUTION_TEMPLATE_FILE);
                compilation = this.compile(project);
            } else {
                ClassLoadContext context = this.createDeclarationContext(this.variableDeclarations.keySet(), this.variableNames, this.moduleDeclarations);
                this.project = this.getProject(context, DECLARATION_TEMPLATE_FILE);
                compilation = this.compile(this.project);
            }
        }
        return compilation;
    }

    @Override
    public Optional<Object> execute(Optional<PackageCompilation> compilation) throws InvokerException {
        if (this.noModuleDeclarations && this.noVariableDeclarations && this.noExecutables) {
            return Optional.empty();
        }
        if (this.noModuleDeclarations && this.noVariableDeclarations) {
            ClassLoadContext execContext = this.createVariablesExecutionContext(List.of(), this.executableSnippets, Map.of());
            this.executeProject(execContext, EXECUTION_TEMPLATE_FILE);
            return Optional.ofNullable(InvokerMemory.recall((String)this.contextId, (String)CONTEXT_EXPR_VAR_NAME));
        }
        Collection<GlobalVariableSymbol> globalVariableSymbols = this.globalVariableSymbols(this.project, compilation.get());
        HashMap<Identifier, GlobalVariable> allNewVariables = new HashMap<Identifier, GlobalVariable>();
        for (VariableDeclarationSnippet variableDeclarationSnippet : this.variableDeclarations.keySet()) {
            Map<Identifier, GlobalVariable> newVariables = this.createGlobalVariables(variableDeclarationSnippet.qualifiersAndMetadata(), variableDeclarationSnippet.names(), globalVariableSymbols, variableDeclarationSnippet.isDeclaredWithVar());
            allNewVariables.putAll(newVariables);
        }
        allNewVariables.keySet().forEach(id -> this.newDefinedVariableNames.add(id.getName()));
        this.globalVars.putAll(allNewVariables);
        this.newImports.forEach(this.importsManager::storeImportUsages);
        this.addDebugDiagnostic("Implicit imports added: " + String.valueOf(this.newImports));
        this.addDebugDiagnostic("Found new variables: " + String.valueOf(allNewVariables));
        for (Map.Entry entry : this.moduleDeclarations.entrySet()) {
            String moduleDclnCode = ((ModuleMemberDeclarationSnippet)entry.getValue()).toString();
            this.moduleDclns.put((Identifier)entry.getKey(), moduleDclnCode);
            this.newModuleDeclnNames.add(((Identifier)entry.getKey()).getName());
            this.addDebugDiagnostic("Module dcln name: " + String.valueOf(entry.getKey()));
            this.addDebugDiagnostic("Module dcln code: " + moduleDclnCode);
        }
        if (this.variableDeclarations.isEmpty() && this.executableSnippets.isEmpty()) {
            return Optional.empty();
        }
        try {
            ClassLoadContext execContext = this.createVariablesExecutionContext(this.variableDeclarations.keySet(), this.executableSnippets, allNewVariables);
            this.executeProject(execContext, EXECUTION_TEMPLATE_FILE);
            return Optional.ofNullable(InvokerMemory.recall((String)this.contextId, (String)CONTEXT_EXPR_VAR_NAME));
        }
        catch (InvokerException e) {
            HashSet<String> hashSet = new HashSet<String>();
            allNewVariables.keySet().forEach(id -> identifiersToDelete.add(id.getName()));
            this.moduleDeclarations.keySet().forEach(id -> identifiersToDelete.add(id.getName()));
            this.delete(hashSet);
            this.clearPreviousVariablesAndModuleDclnsNames();
            throw e;
        }
    }

    @Override
    public void delete(Set<String> declarationNames) throws InvokerException {
        HashMap<Identifier, GlobalVariable> queuedGlobalVars = new HashMap<Identifier, GlobalVariable>();
        HashMap<Identifier, String> queuedModuleDclns = new HashMap<Identifier, String>();
        for (String declarationName : declarationNames) {
            Identifier identifier = new Identifier(declarationName);
            if (this.globalVars.containsKey(identifier)) {
                queuedGlobalVars.put(identifier, this.globalVars.get(identifier));
                continue;
            }
            if (this.moduleDclns.containsKey(identifier)) {
                queuedModuleDclns.put(identifier, this.moduleDclns.get(identifier));
                continue;
            }
            this.addErrorDiagnostic(declarationName + " is not defined.\nPlease enter names of declarations that are already defined.");
            throw new InvokerException();
        }
        try {
            queuedGlobalVars.keySet().forEach(this.globalVars::remove);
            queuedModuleDclns.keySet().forEach(this.moduleDclns::remove);
            this.processCurrentState();
        }
        catch (InvokerException e) {
            this.globalVars.putAll(queuedGlobalVars);
            this.moduleDclns.putAll(queuedModuleDclns);
            this.addErrorDiagnostic("Deleting declaration(s) failed.");
            throw e;
        }
    }

    private void processImport(ImportDeclarationSnippet importSnippet) throws InvokerException {
        QuotedImport quotedImport = importSnippet.getImportedModule();
        Identifier prefix = importSnippet.getPrefix();
        if (this.importsManager.moduleImported(quotedImport) && this.importsManager.prefix(quotedImport).equals(prefix) && this.importsManager.containsPrefix(prefix)) {
            this.addDebugDiagnostic("Detected reimport: " + String.valueOf(prefix));
            return;
        }
        if (this.importsManager.containsPrefix(prefix)) {
            this.addErrorDiagnostic("The import prefix was already used by another import.");
            throw new InvokerException();
        }
        this.compileImportStatement(importSnippet.toString());
        this.addDebugDiagnostic("Adding import: " + String.valueOf(importSnippet));
        this.importsManager.storeImport(importSnippet);
    }

    private void processCurrentState() throws InvokerException {
        Set<String> importStrings = this.getRequiredImportStatements();
        ClassLoadContext context = new ClassLoadContext(this.contextId, importStrings, this.moduleDclns.values(), this.globalVariableContexts().values(), null, null);
        Project project = this.getProject(context, DECLARATION_TEMPLATE_FILE);
        this.compile(project);
    }

    private ClassLoadContext createDeclarationContext(Collection<VariableDeclarationSnippet> variableDeclarations, Collection<Identifier> variableNames, Map<Identifier, ModuleMemberDeclarationSnippet> moduleDeclarations) {
        Map<Identifier, VariableContext> oldVarDclns = this.globalVariableContexts();
        HashMap<Identifier, String> moduleDclnStringsMap = new HashMap<Identifier, String>(this.moduleDclns);
        StringJoiner lastVarDclns = new StringJoiner("\n");
        HashSet<String> importStrings = new HashSet<String>();
        for (Map.Entry<Identifier, ModuleMemberDeclarationSnippet> dcln : moduleDeclarations.entrySet()) {
            importStrings.addAll(this.getRequiredImportStatements(dcln.getValue()));
            moduleDclnStringsMap.put(dcln.getKey(), dcln.getValue().toString());
        }
        variableNames.forEach(oldVarDclns::remove);
        for (VariableDeclarationSnippet varSnippet : variableDeclarations) {
            lastVarDclns.add(varSnippet.toString());
            importStrings.addAll(this.getRequiredImportStatements(varSnippet));
        }
        Collection variableNameStrs = variableNames.stream().map(Identifier::getName).collect(Collectors.toSet());
        return new ClassLoadContext(this.contextId, importStrings, moduleDclnStringsMap.values(), oldVarDclns.values(), variableNameStrs, lastVarDclns.toString());
    }

    private ClassLoadContext createVariablesExecutionContext(Collection<VariableDeclarationSnippet> variableDeclarationSnippets, Collection<ExecutableSnippet> executableSnippets, Map<Identifier, GlobalVariable> newVariables) {
        Map<Identifier, VariableContext> varDclnsMap = this.globalVariableContexts();
        StringJoiner newVariableDclns = new StringJoiner("\n");
        HashSet<String> importStrings = new HashSet<String>();
        for (VariableDeclarationSnippet snippet : variableDeclarationSnippets) {
            importStrings.addAll(this.getRequiredImportStatements(snippet));
            newVariableDclns.add(snippet.toString());
        }
        ArrayList<StatementContext> lastStatements = new ArrayList<StatementContext>();
        for (ExecutableSnippet newSnippet : executableSnippets) {
            importStrings.addAll(this.getRequiredImportStatements(newSnippet));
            boolean isStatement = newSnippet instanceof StatementSnippet;
            lastStatements.add(new StatementContext(newSnippet.toString(), isStatement));
        }
        newVariables.forEach((k, v) -> varDclnsMap.put((Identifier)k, VariableContext.newVar(v)));
        return new ClassLoadContext(this.contextId, importStrings, this.moduleDclns.values(), varDclnsMap.values(), null, newVariableDclns.toString(), lastStatements);
    }

    private Map<Identifier, VariableContext> globalVariableContexts() {
        HashMap<Identifier, VariableContext> varDclns = new HashMap<Identifier, VariableContext>();
        this.globalVars.forEach((k, v) -> varDclns.put((Identifier)k, VariableContext.oldVar(v)));
        return varDclns;
    }

    private Map<Identifier, GlobalVariable> createGlobalVariables(String qualifiersAndMetadata, Set<Identifier> definedVariables, Collection<GlobalVariableSymbol> globalVarSymbols, boolean isDeclaredWithVar) {
        HashMap<Identifier, GlobalVariable> foundVariables = new HashMap<Identifier, GlobalVariable>();
        this.addDebugDiagnostic("Found variables: " + String.valueOf(definedVariables));
        for (GlobalVariableSymbol globalVariableSymbol : globalVarSymbols) {
            Identifier variableName = globalVariableSymbol.getName();
            Identifier variableNameConverted = new Identifier(variableName.getUnicodeConvertedName());
            TypeSymbol typeSymbol = globalVariableSymbol.getTypeSymbol();
            if (this.initialIdentifiers.contains(variableName) || !definedVariables.contains(variableName) && !definedVariables.contains(variableNameConverted)) continue;
            boolean isAssignableToAny = typeSymbol.subtypeOf(this.anyTypeSymbol);
            HashSet<Identifier> requiredImports = new HashSet<Identifier>();
            String variableType = this.importsManager.extractImportsFromType(typeSymbol, requiredImports);
            this.newImports.put(new Identifier(variableName.getName()), requiredImports);
            GlobalVariable globalVariable = new GlobalVariable(variableType, isDeclaredWithVar, variableName, isAssignableToAny, qualifiersAndMetadata);
            foundVariables.put(variableName, globalVariable);
        }
        return foundVariables;
    }

    private Collection<GlobalVariableSymbol> globalVariableSymbols(Project project, PackageCompilation compilation) {
        ModuleId moduleId = project.currentPackage().getDefaultModule().moduleId();
        return compilation.getSemanticModel(moduleId).moduleSymbols().stream().filter(s -> s instanceof VariableSymbol || s instanceof FunctionSymbol).map(GlobalVariableSymbol::fromSymbol).toList();
    }

    private Set<String> getRequiredImportStatements(Snippet snippet) {
        Set<String> importStrings = this.getRequiredImportStatements();
        snippet.usedImports().stream().map(Identifier::new).map(this.importsManager::getImport).filter(Objects::nonNull).forEach(importStrings::add);
        return importStrings;
    }

    private Set<String> getRequiredImportStatements() {
        HashSet<String> importStrings = new HashSet<String>();
        importStrings.addAll(this.importsManager.getUsedImports(this.globalVars.keySet()));
        importStrings.addAll(this.importsManager.getUsedImports(this.moduleDclns.keySet()));
        return importStrings;
    }

    @Override
    public List<String> availableImports() {
        ArrayList<String> importStrings = new ArrayList<String>();
        for (Identifier prefix : this.importsManager.prefixes()) {
            String importStatement = String.format("(%s) %s", prefix, this.importsManager.getImport(prefix));
            importStrings.add(importStatement);
        }
        return importStrings;
    }

    @Override
    public List<String> availableVariables() {
        String varString;
        ArrayList<String> varStrings = new ArrayList<String>();
        ArrayList<String> variablesDeclarations = new ArrayList<String>();
        ArrayList<String> finalVariablesDeclarations = new ArrayList<String>();
        ArrayList<String> constDeclarations = new ArrayList<String>();
        for (GlobalVariable globalVariable : this.globalVars.values()) {
            Object obj = InvokerMemory.recall((String)this.contextId, (String)globalVariable.getVariableName().getName());
            String objStr = StringUtils.getExpressionStringValue(obj);
            String value = StringUtils.shortenedString(objStr);
            if (!globalVariable.getQualifiersAndMetadata().isEmpty()) {
                varString = String.format("(%s) %s %s %s = %s", globalVariable.getVariableName().getUnicodeConvertedName(), globalVariable.getQualifiersAndMetadata().strip(), globalVariable.getType(), globalVariable.getVariableName().getUnicodeConvertedName(), value);
                finalVariablesDeclarations.add(varString);
                continue;
            }
            varString = String.format("(%s) %s %s = %s", globalVariable.getVariableName().getUnicodeConvertedName(), globalVariable.getType(), globalVariable.getVariableName().getUnicodeConvertedName(), value);
            variablesDeclarations.add(varString);
        }
        for (Map.Entry entry : this.availableModuleDeclarations.entrySet()) {
            if (((ModuleMemberDeclarationSnippet)entry.getValue()).getRootNode().kind() != SyntaxKind.CONST_DECLARATION) continue;
            ConstantDeclarationNode constantDeclarationNode = (ConstantDeclarationNode)((ModuleMemberDeclarationSnippet)entry.getValue()).getRootNode();
            String varName = StringUtils.convertUnicodeToCharacter(constantDeclarationNode.variableName().text());
            String constKeyword = constantDeclarationNode.constKeyword().text();
            String value = constantDeclarationNode.initializer().toString();
            Optional typeDescriptorNode = constantDeclarationNode.typeDescriptor();
            varString = typeDescriptorNode.isPresent() ? String.format("(%s) %s %s %s = %s", varName, constKeyword, ((TypeDescriptorNode)typeDescriptorNode.get()).toString().strip(), varName, value) : String.format("(%s) %s %s = %s", varName, constKeyword, varName, value);
            constDeclarations.add(varString);
        }
        if (!variablesDeclarations.isEmpty()) {
            varStrings.add("Variable declarations");
            varStrings.addAll(variablesDeclarations);
        }
        if (!finalVariablesDeclarations.isEmpty()) {
            varStrings.add("Final variable declarations");
            varStrings.addAll(finalVariablesDeclarations);
        }
        if (!constDeclarations.isEmpty()) {
            varStrings.add("Constant declarations");
            varStrings.addAll(constDeclarations);
        }
        return varStrings;
    }

    @Override
    public List<AvailableVariable> availableVariablesAsObjects() {
        ArrayList<AvailableVariable> varMap = new ArrayList<AvailableVariable>();
        for (GlobalVariable entry : this.globalVars.values()) {
            String type = entry.getType();
            Object obj = InvokerMemory.recall((String)this.contextId, (String)entry.getVariableName().getName());
            String objStr = StringUtils.getExpressionStringValue(obj);
            AvailableVariable varObject = new AvailableVariable(entry.getVariableName().getUnicodeConvertedName(), type, objStr);
            varMap.add(varObject);
        }
        return varMap;
    }

    @Override
    public List<String> availableModuleDeclarations() {
        ArrayList<String> moduleDclnStrings = new ArrayList<String>();
        for (Map.Entry<Identifier, ModuleMemberDeclarationSnippet> entry : this.availableModuleDeclarations.entrySet()) {
            if (entry.getValue().getRootNode().kind() == SyntaxKind.CONST_DECLARATION) continue;
            String varString = String.format("(%s) %s", entry.getKey(), StringUtils.shortenedString(entry.getValue()));
            moduleDclnStrings.add(varString);
        }
        return moduleDclnStrings;
    }

    @Override
    public List<String> newVariableNames() {
        return this.newDefinedVariableNames;
    }

    @Override
    public List<String> newModuleDeclarations() {
        return this.newModuleDeclnNames;
    }

    @Override
    public void clearPreviousVariablesAndModuleDclnsNames() {
        this.newDefinedVariableNames.clear();
        this.newModuleDeclnNames.clear();
    }

    @Override
    protected PrintStream getErrorStream() {
        return System.err;
    }
}

