/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker.classload;

import io.ballerina.shell.utils.Identifier;
import java.util.Objects;

public class GlobalVariable {
    private final String type;
    private final Identifier variableName;
    private final boolean isAssignableToAny;
    private final String qualifiersAndMetadata;
    private final boolean isDeclaredWithVar;

    public GlobalVariable(String type, boolean isDeclaredWithVar, Identifier variableName, boolean isAssignableToAny, String qualifiersAndMetadata) {
        this.type = Objects.requireNonNull(type);
        this.isAssignableToAny = isAssignableToAny;
        this.qualifiersAndMetadata = Objects.requireNonNull(qualifiersAndMetadata);
        this.variableName = variableName;
        this.isDeclaredWithVar = isDeclaredWithVar;
    }

    public String getType() {
        return this.type;
    }

    public boolean isDeclaredWithVar() {
        return this.isDeclaredWithVar;
    }

    public Identifier getVariableName() {
        return this.variableName;
    }

    public boolean isAssignableToAny() {
        return this.isAssignableToAny;
    }

    public String getQualifiersAndMetadata() {
        return this.qualifiersAndMetadata;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GlobalVariable that = (GlobalVariable)o;
        return this.variableName.equals(that.variableName);
    }

    public int hashCode() {
        return Objects.hash(this.variableName);
    }

    public String toString() {
        String elevType = this.isAssignableToAny ? "any" : "any|error";
        return String.format("<%s> %s %s %s", elevType, this.qualifiersAndMetadata, this.type, this.variableName);
    }
}

