/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker.classload;

import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.shell.utils.Identifier;

public class GlobalVariableSymbol {
    private final Identifier name;
    private final TypeSymbol typeSymbol;

    private GlobalVariableSymbol(String name, TypeSymbol typeSymbol) {
        this.name = new Identifier(name);
        this.typeSymbol = typeSymbol;
    }

    public static GlobalVariableSymbol fromSymbol(Symbol symbol) {
        if (symbol.getName().isEmpty()) {
            throw new UnsupportedOperationException("Cannot create a global symbol without name");
        }
        if (symbol instanceof VariableSymbol) {
            VariableSymbol variableSymbol = (VariableSymbol)symbol;
            return new GlobalVariableSymbol((String)symbol.getName().get(), variableSymbol.typeDescriptor());
        }
        if (symbol instanceof FunctionSymbol) {
            FunctionSymbol functionSymbol = (FunctionSymbol)symbol;
            return new GlobalVariableSymbol((String)symbol.getName().get(), (TypeSymbol)functionSymbol.typeDescriptor());
        }
        throw new UnsupportedOperationException("Symbol type not supported for creating global variable.");
    }

    public Identifier getName() {
        return this.name;
    }

    public TypeSymbol getTypeSymbol() {
        return this.typeSymbol;
    }
}

