/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker.classload;

import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.shell.snippet.types.ImportDeclarationSnippet;
import io.ballerina.shell.utils.Identifier;
import io.ballerina.shell.utils.QuotedImport;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ImportsManager {
    private static final Identifier ANON_SOURCE = new Identifier("$");
    private static final Pattern FULLY_QUALIFIED_MODULE_ID_PATTERN = Pattern.compile("([\\w]+)/([\\w.]+):([^:]+):([\\w]+)[|]?");
    private static final String CLONEABLE_TYPE_DEF = "ballerina/lang.value:0:Cloneable";
    private static final String JAVA_IMPORT_SOURCE = "import ballerina/jballerina.java;";
    private static final ImportDeclarationSnippet JAVA_IMPORT;
    private static final String JAVA_PREFIX = "java";
    public static final String QUOTE = "'";
    private final AtomicBoolean initialized = new AtomicBoolean(false);
    private static final AtomicInteger implicitImportPrefixIndex;
    private static final List<String> BALLERINA_KEYWORDS;
    private final HashMap<Identifier, QuotedImport> imports = new HashMap();
    private final HashMap<Identifier, QuotedImport> userImports = new HashMap();
    private final HashMap<QuotedImport, Identifier> reverseImports = new HashMap();
    private final Map<Identifier, Set<Identifier>> usedPrefixes = new HashMap<Identifier, Set<Identifier>>();

    public ImportsManager() {
        this.storeAnonImplicitPrefixes();
    }

    public void reset() {
        this.imports.clear();
        this.reverseImports.clear();
        this.usedPrefixes.clear();
        this.userImports.clear();
        this.storeAnonImplicitPrefixes();
    }

    public String getImport(Identifier prefix) {
        QuotedImport quotedImport = this.imports.get(prefix);
        if (quotedImport == null) {
            return null;
        }
        if (quotedImport.getDefaultPrefix().equals(prefix)) {
            return String.format("import %s;", quotedImport);
        }
        return String.format("import %s as %s;", quotedImport, prefix);
    }

    public boolean containsPrefix(Identifier prefix) {
        return this.userImports.containsKey(prefix) || this.userImports.containsKey(new Identifier(QUOTE + String.valueOf(prefix)));
    }

    public boolean moduleImported(QuotedImport moduleName) {
        return this.reverseImports.containsKey(moduleName);
    }

    public Identifier prefix(QuotedImport moduleName) {
        return this.reverseImports.get(moduleName);
    }

    public void storeImport(ImportDeclarationSnippet snippet) {
        Identifier quotedPrefix = snippet.getPrefix();
        QuotedImport importedModule = snippet.getImportedModule();
        this.storeImport(quotedPrefix, importedModule);
    }

    public void storeImportUsages(Identifier name, Collection<Identifier> prefixes) {
        Set sourcePrefixes = this.usedPrefixes.getOrDefault(name, new HashSet());
        sourcePrefixes.addAll(prefixes);
        this.usedPrefixes.put(name, sourcePrefixes);
    }

    public Set<Identifier> prefixes() {
        return this.userImports.keySet();
    }

    public Set<String> getUsedImports(Collection<Identifier> names) {
        HashSet allUsedImportPrefixes = new HashSet(this.usedPrefixes.get(ANON_SOURCE));
        names.stream().map(this.usedPrefixes::get).filter(Objects::nonNull).forEach(allUsedImportPrefixes::addAll);
        HashSet<String> importStrings = new HashSet<String>();
        allUsedImportPrefixes.stream().map(this::getImport).filter(Objects::nonNull).forEach(importStrings::add);
        return importStrings;
    }

    protected String extractImportsFromType(TypeSymbol typeSymbol, Set<Identifier> imports) {
        String text = typeSymbol.signature();
        StringBuilder newText = new StringBuilder();
        Matcher matcher = FULLY_QUALIFIED_MODULE_ID_PATTERN.matcher(text);
        int nextStart = 0;
        while (matcher.find()) {
            newText.append(text, nextStart, matcher.start(1));
            String orgName = matcher.group(1);
            List<String> moduleNames = Arrays.asList(matcher.group(2).split("\\."));
            for (int i = 1; i < moduleNames.size(); ++i) {
                if (!BALLERINA_KEYWORDS.contains(moduleNames.get(i))) continue;
                moduleNames.set(i, QUOTE + moduleNames.get(i));
            }
            QuotedImport quotedImport = new QuotedImport(orgName, moduleNames);
            Identifier quotedPrefix = this.addImport(quotedImport);
            imports.add(quotedPrefix);
            newText.append(quotedPrefix.getName()).append(":");
            nextStart = matcher.end(3) + 1;
        }
        if (nextStart != 0) {
            newText.append(text.substring(nextStart));
        }
        return !newText.isEmpty() ? newText.toString() : text;
    }

    private Identifier addImport(QuotedImport moduleName) {
        if (this.moduleImported(moduleName)) {
            return this.prefix(moduleName);
        }
        Identifier quotedPrefix = moduleName.getDefaultPrefix();
        while (this.containsPrefix(quotedPrefix)) {
            quotedPrefix = new Identifier("_" + implicitImportPrefixIndex.incrementAndGet());
        }
        return quotedPrefix;
    }

    private void storeAnonImplicitPrefixes() {
        this.storeImport(JAVA_IMPORT);
        this.storeImportUsages(ANON_SOURCE, List.of(JAVA_IMPORT.getPrefix()));
        this.initialized.set(true);
    }

    private void storeImport(Identifier quotedPrefix, QuotedImport moduleName) {
        this.imports.put(quotedPrefix, moduleName);
        this.reverseImports.put(moduleName, quotedPrefix);
        if (!quotedPrefix.toString().equals(JAVA_PREFIX)) {
            this.userImports.put(quotedPrefix, moduleName);
        } else if (this.initialized.get()) {
            this.userImports.put(quotedPrefix, moduleName);
        }
    }

    private static List<String> getBallerinaKeywords() {
        try {
            Class<?> aClass = Class.forName("io.ballerina.compiler.internal.parser.LexerTerminals");
            return Arrays.stream(aClass.getDeclaredFields()).filter(field -> field.getModifiers() == 25 && field.getType() == String.class).map(field -> {
                try {
                    return field.get(null).toString();
                }
                catch (IllegalAccessException e) {
                    return null;
                }
            }).filter(Objects::nonNull).toList();
        }
        catch (ClassNotFoundException e) {
            return Collections.emptyList();
        }
    }

    static {
        implicitImportPrefixIndex = new AtomicInteger(0);
        TextDocument importText = TextDocuments.from((String)JAVA_IMPORT_SOURCE);
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)importText);
        assert (syntaxTree.rootNode() instanceof ModulePartNode);
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        ImportDeclarationNode importDeclaration = (ImportDeclarationNode)modulePartNode.imports().get(0);
        JAVA_IMPORT = new ImportDeclarationSnippet(importDeclaration);
        BALLERINA_KEYWORDS = ImportsManager.getBallerinaKeywords();
    }
}

