/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.invoker.classload.context;

import io.ballerina.shell.invoker.classload.GlobalVariable;
import io.ballerina.shell.utils.StringUtils;

public class VariableContext {
    private final String prefix;
    private final String name;
    private final String type;
    private final boolean isAssignedWithVar;
    private final boolean isNew;
    private final boolean isAny;
    private static final String VAR = "var";

    private VariableContext(String prefix, String name, String type, boolean isDeclaredWithVar, boolean isNew, boolean isAny) {
        this.prefix = prefix;
        this.name = StringUtils.quoted(name);
        this.type = type;
        this.isAssignedWithVar = isDeclaredWithVar;
        this.isNew = isNew;
        this.isAny = isAny;
    }

    public static VariableContext newVar(GlobalVariable variableEntry) {
        return new VariableContext(variableEntry.getQualifiersAndMetadata(), variableEntry.getVariableName().getName(), variableEntry.getType(), variableEntry.isDeclaredWithVar(), true, variableEntry.isAssignableToAny());
    }

    public static VariableContext oldVar(GlobalVariable variableEntry) {
        return new VariableContext(variableEntry.getQualifiersAndMetadata(), variableEntry.getVariableName().getName(), variableEntry.getType(), variableEntry.isDeclaredWithVar(), false, variableEntry.isAssignableToAny());
    }

    public String prefix() {
        return this.prefix;
    }

    public String name() {
        return this.name;
    }

    public String encodedName() {
        return StringUtils.encodeIdentifier(this.name);
    }

    public String type() {
        return this.type;
    }

    public String typeLHS() {
        return this.isAssignedWithVar ? VAR : this.type;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public boolean isAny() {
        return this.isAny;
    }
}

