/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.shell.exceptions.TreeParserException;
import io.ballerina.shell.parser.ParserConstants;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.EmptyExpressionTrial;
import io.ballerina.shell.parser.trials.ExpressionListTrial;
import io.ballerina.shell.parser.trials.ExpressionTrial;
import io.ballerina.shell.parser.trials.GetErrorMessageTrial;
import io.ballerina.shell.parser.trials.InvalidMethodException;
import io.ballerina.shell.parser.trials.ModuleMemberTrial;
import io.ballerina.shell.parser.trials.ModulePartTrial;
import io.ballerina.shell.parser.trials.ParserRejectedException;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.shell.parser.trials.StatementTrial;
import io.ballerina.shell.parser.trials.TreeParserTrial;
import io.ballerina.shell.parser.trials.WorkerDeclarationTrial;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SerialTreeParser
extends TrialTreeParser {
    private static final String COMMAND_PREFIX = "/";
    private final List<TreeParserTrial> nodeParserTrials = List.of(new ModuleMemberTrial(this), new ExpressionTrial(this), new ExpressionListTrial(this), new StatementTrial(this), new WorkerDeclarationTrial(this), new EmptyExpressionTrial(this), new GetErrorMessageTrial(this));

    public SerialTreeParser(long timeOutDurationMs) {
        super(timeOutDurationMs);
    }

    @Override
    public Collection<Node> parse(String source) throws TreeParserException {
        Object errorMessage = "";
        for (TreeParserTrial trial : this.nodeParserTrials) {
            try {
                return Objects.requireNonNull(trial.parse(source), "trial returned no nodes");
            }
            catch (ParserTrialFailedException e) {
                errorMessage = e.getMessage();
            }
            catch (ParserRejectedException e) {
                errorMessage = "Invalid statement: " + e.getMessage();
                break;
            }
            catch (InvalidMethodException e) {
                errorMessage = e.getMessage();
                this.addErrorDiagnostic((String)errorMessage);
                throw new TreeParserException();
            }
            catch (Throwable e) {
                errorMessage = "Code contains syntax error(s).";
            }
        }
        if (source.startsWith(COMMAND_PREFIX)) {
            errorMessage = "Can not find the command: " + source.trim();
            this.addErrorDiagnostic((String)errorMessage);
            this.addErrorDiagnostic("Please use \"/help\" command to view available commands.");
        } else {
            this.addErrorDiagnostic((String)errorMessage);
            this.addErrorDiagnostic("Parsing aborted due to errors.");
        }
        throw new TreeParserException();
    }

    @Override
    public Collection<Node> parseDeclarations(String source) throws TreeParserException {
        try {
            ModulePartTrial modulePartTrial = new ModulePartTrial(this);
            Collection<Node> nodes = modulePartTrial.parse(source);
            ArrayList<Node> declarationNodes = new ArrayList<Node>();
            for (Node node : nodes) {
                ModulePartNode modulePartNode = (ModulePartNode)node;
                modulePartNode.imports().forEach(declarationNodes::add);
                modulePartNode.members().stream().filter(this::isModuleDeclarationAllowed).forEach(declarationNodes::add);
            }
            return declarationNodes;
        }
        catch (ParserTrialFailedException e) {
            this.addErrorDiagnostic(e.getMessage());
            this.addErrorDiagnostic("Parsing aborted because of errors.");
            throw new TreeParserException();
        }
    }

    private boolean isModuleDeclarationAllowed(ModuleMemberDeclarationNode declarationNode) {
        FunctionDefinitionNode functionDefinitionNode;
        String functionName;
        if (declarationNode instanceof FunctionDefinitionNode && ParserConstants.isFunctionNameRestricted(functionName = (functionDefinitionNode = (FunctionDefinitionNode)declarationNode).functionName().text())) {
            this.addWarnDiagnostic("Found '" + functionName + "' function in the declarations.\nDiscarded '" + functionName + "' function without loading.");
            return false;
        }
        return true;
    }
}

