/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser.trials;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.shell.parser.ParserConstants;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.InvalidMethodException;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.shell.parser.trials.TreeParserTrial;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class ModuleMemberTrial
extends TreeParserTrial {
    public ModuleMemberTrial(TrialTreeParser parentParser) {
        super(parentParser);
    }

    @Override
    public Collection<Node> parse(String source) throws ParserTrialFailedException {
        SyntaxTree tree;
        TextDocument document = TextDocuments.from((String)source);
        try {
            tree = this.getSyntaxTree(document);
        }
        catch (ParserTrialFailedException e) {
            document = TextDocuments.from((String)(source + ";"));
            tree = this.getSyntaxTree(document);
        }
        ArrayList<Node> nodes = new ArrayList<Node>();
        ModulePartNode node = (ModulePartNode)tree.rootNode();
        NodeList members = node.members();
        Iterator importIterator = node.imports().iterator();
        Iterator memberIterator = members.iterator();
        while (importIterator.hasNext()) {
            nodes.add((Node)importIterator.next());
        }
        while (memberIterator.hasNext()) {
            ModuleMemberDeclarationNode dclnNode = (ModuleMemberDeclarationNode)memberIterator.next();
            this.validateModuleDeclaration(dclnNode);
            nodes.add((Node)dclnNode);
        }
        return nodes;
    }

    private void validateModuleDeclaration(ModuleMemberDeclarationNode declarationNode) {
        FunctionDefinitionNode functionDefinitionNode;
        String functionName;
        if (declarationNode instanceof FunctionDefinitionNode && ParserConstants.isFunctionNameRestricted(functionName = (functionDefinitionNode = (FunctionDefinitionNode)declarationNode).functionName().text())) {
            String message = "Function name '" + functionName + "' not allowed in Ballerina Shell.\n";
            throw new InvalidMethodException(message);
        }
    }
}

