/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.parser.trials;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.shell.parser.TrialTreeParser;
import io.ballerina.shell.parser.trials.ParserTrialFailedException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class TreeParserTrial {
    protected final TrialTreeParser parentParser;

    protected TreeParserTrial(TrialTreeParser parentParser) {
        this.parentParser = parentParser;
    }

    public abstract Collection<Node> parse(String var1) throws ParserTrialFailedException;

    protected SyntaxTree getSyntaxTree(TextDocument document) throws ParserTrialFailedException {
        SyntaxTree tree;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<SyntaxTree> future = executor.submit(() -> SyntaxTree.from((TextDocument)document));
        executor.shutdown();
        try {
            tree = future.get(this.getTimeOutDurationMs(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new ParserTrialFailedException("Tree parsing was interrupted.");
        }
        catch (ExecutionException e) {
            throw new ParserTrialFailedException("Executor failure because " + e.getCause().getMessage());
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new ParserTrialFailedException("Tree parsing was timed out.");
        }
        for (Diagnostic diagnostic : tree.diagnostics()) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            throw new ParserTrialFailedException(tree.textDocument(), diagnostic);
        }
        return tree;
    }

    protected void assertIf(boolean condition, String message) throws ParserTrialFailedException {
        if (!condition) {
            throw new ParserTrialFailedException(message);
        }
    }

    protected long getTimeOutDurationMs() {
        return this.parentParser.getTimeOutDurationMs();
    }
}

