/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.preprocessor;

import io.ballerina.shell.exceptions.PreprocessorException;
import io.ballerina.shell.preprocessor.Preprocessor;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class SeparatorPreprocessor
extends Preprocessor {
    private static final char ESCAPE_CHAR = '\\';
    private static final char BACK_TICK = '`';
    private static final char DOUBLE_QUOTE = '\"';
    private static final char SEMICOLON = ';';
    private static final char PARENTHESIS_OPEN = '(';
    private static final char PARENTHESIS_CLOSE = ')';
    private static final char SQUARE_BR_OPEN = '[';
    private static final char SQUARE_BR_CLOSE = ']';
    private static final char CURLY_BR_OPEN = '{';
    private static final char CURLY_BR_CLOSE = '}';
    private static final char COMMENT_START = '/';
    private static final char NEW_LINE = '\n';

    @Override
    public Collection<String> process(String input) throws PreprocessorException {
        ArrayList<String> snippets = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        ArrayDeque<Character> brackets = new ArrayDeque<Character>();
        boolean isInBacktickLiteral = false;
        boolean isInQuoteLiteral = false;
        boolean isInComment = false;
        for (int i = 0; i < input.length(); ++i) {
            char character = input.charAt(i);
            if (isInComment && character == '\n') {
                isInComment = false;
            }
            if (isInComment) continue;
            builder.append(character);
            if (character == '\"' && this.isNotEscaped(input, i)) {
                isInQuoteLiteral = !isInQuoteLiteral;
            } else if (character == '`' && this.isNotEscaped(input, i)) {
                boolean bl = isInBacktickLiteral = !isInBacktickLiteral;
            }
            if (isInBacktickLiteral || isInQuoteLiteral) continue;
            isInComment = this.isCommentStart(input, i);
            if (isInComment) {
                builder.deleteCharAt(builder.length() - 1);
                continue;
            }
            if (character == ';' && brackets.isEmpty()) {
                this.addToList(snippets, builder);
                builder.setLength(0);
                continue;
            }
            if (this.isOpeningBracket(character)) {
                brackets.push(Character.valueOf(character));
                continue;
            }
            if (!brackets.isEmpty() && this.isBracketPair(((Character)brackets.peek()).charValue(), character)) {
                brackets.pop();
                continue;
            }
            if (!this.isClosingBracket(character) || !brackets.isEmpty()) continue;
            this.addErrorDiagnostic("syntax error: found closing brackets but opening one not found.");
            throw new PreprocessorException();
        }
        if (!builder.isEmpty()) {
            this.addToList(snippets, builder);
        }
        return snippets;
    }

    private void addToList(List<String> stack, StringBuilder builder) {
        Object string = builder.toString().trim();
        if (((String)string).isBlank()) {
            return;
        }
        if (!((String)string).endsWith(String.valueOf(';'))) {
            string = (String)string + ";";
        }
        if (((String)string).length() == 1) {
            return;
        }
        stack.add((String)string);
    }

    private boolean isCommentStart(String input, int position) {
        return position < input.length() - 1 && input.charAt(position) == '/' && input.charAt(position + 1) == '/';
    }

    private boolean isNotEscaped(String input, int position) {
        return position <= 0 || input.charAt(position - 1) != '\\';
    }

    private boolean isOpeningBracket(char character) {
        return character == '(' || character == '[' || character == '{';
    }

    private boolean isClosingBracket(char character) {
        return character == ')' || character == ']' || character == '}';
    }

    private boolean isBracketPair(char opening, char closing) {
        return opening == '(' && closing == ')' || opening == '[' && closing == ']' || opening == '{' && closing == '}';
    }
}

