/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.shell.snippet.types;

import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.FieldBindingPatternVarnameNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.RestBindingPatternNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.shell.snippet.SnippetSubKind;
import io.ballerina.shell.snippet.types.AbstractSnippet;
import io.ballerina.shell.snippet.types.TopLevelDeclarationSnippet;
import io.ballerina.shell.utils.Identifier;
import io.ballerina.shell.utils.StringUtils;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class VariableDeclarationSnippet
extends AbstractSnippet<ModuleVariableDeclarationNode>
implements TopLevelDeclarationSnippet {
    private Set<Identifier> names;

    public VariableDeclarationSnippet(ModuleVariableDeclarationNode rootNode) {
        super(SnippetSubKind.VARIABLE_DECLARATION, rootNode);
    }

    public String qualifiersAndMetadata() {
        String metadata = ((ModuleVariableDeclarationNode)this.rootNode).metadata().map(Node::toSourceCode).orElse("");
        String qualifiers = ((ModuleVariableDeclarationNode)this.rootNode).qualifiers().stream().map(Node::toSourceCode).collect(Collectors.joining(" "));
        return metadata + qualifiers;
    }

    public Set<Identifier> names() {
        if (this.names != null) {
            return this.names;
        }
        this.names = new HashSet<Identifier>();
        ((ModuleVariableDeclarationNode)this.rootNode).typedBindingPattern().bindingPattern().accept((NodeVisitor)new VariableNameFinder(this.names));
        return this.names;
    }

    public boolean isDeclaredWithVar() {
        return SyntaxKind.VAR_TYPE_DESC == ((ModuleVariableDeclarationNode)this.rootNode).typedBindingPattern().typeDescriptor().kind();
    }

    private static class VariableNameFinder
    extends NodeVisitor {
        private final Set<Identifier> foundVariableIdentifiers;

        public VariableNameFinder(Set<Identifier> foundVariableIdentifiers) {
            this.foundVariableIdentifiers = foundVariableIdentifiers;
        }

        public void visit(CaptureBindingPatternNode captureBindingPatternNode) {
            this.addIdentifier(captureBindingPatternNode.variableName());
        }

        public void visit(RestBindingPatternNode restBindingPatternNode) {
            this.addIdentifier(restBindingPatternNode.variableName().name());
        }

        public void visit(FieldBindingPatternVarnameNode fieldBindingPatternVarnameNode) {
            this.addIdentifier(fieldBindingPatternVarnameNode.variableName().name());
        }

        private void addIdentifier(Token token) {
            String unescapedIdentifier = StringUtils.unescapeUnicodeCodepoints(token.text());
            this.foundVariableIdentifiers.add(new Identifier(unescapedIdentifier));
        }
    }
}

