/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.pop3;

import com.icegreen.greenmail.pop3.Pop3Connection;
import com.icegreen.greenmail.pop3.Pop3State;
import com.icegreen.greenmail.pop3.commands.Pop3Command;
import com.icegreen.greenmail.pop3.commands.Pop3CommandRegistry;
import com.icegreen.greenmail.server.BuildInfo;
import com.icegreen.greenmail.server.ProtocolHandler;
import com.icegreen.greenmail.user.UserManager;
import java.io.IOException;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.StringTokenizer;

public class Pop3Handler
implements ProtocolHandler {
    Pop3CommandRegistry registry;
    Pop3Connection conn;
    UserManager manager;
    Pop3State state;
    boolean quitting;
    String currentLine;
    private Socket socket;

    public Pop3Handler(Pop3CommandRegistry registry, UserManager manager, Socket socket) {
        this.registry = registry;
        this.manager = manager;
        this.socket = socket;
    }

    @Override
    public void run() {
        try {
            this.conn = new Pop3Connection(this, this.socket);
            this.state = new Pop3State(this.manager);
            this.quitting = false;
            this.sendGreetings();
            while (!this.quitting) {
                this.handleCommand();
            }
            this.conn.close();
        }
        catch (SocketTimeoutException ste) {
            this.conn.println("421 Service shutting down and closing transmission channel");
        }
        catch (Exception exception) {
        }
        finally {
            try {
                this.socket.close();
            }
            catch (IOException iOException) {}
        }
    }

    void sendGreetings() {
        this.conn.println("+OK POP3 GreenMail Server v" + BuildInfo.INSTANCE.getProjectVersion() + " ready");
    }

    void handleCommand() throws IOException {
        this.currentLine = this.conn.readLine();
        if (this.currentLine == null) {
            this.close();
            return;
        }
        String commandName = new StringTokenizer(this.currentLine, " ").nextToken().toUpperCase();
        Pop3Command command = this.registry.getCommand(commandName);
        if (command == null) {
            this.conn.println("-ERR Command not recognized");
            return;
        }
        if (!command.isValidForState(this.state)) {
            this.conn.println("-ERR Command not valid for this state");
            return;
        }
        command.execute(this.conn, this.state, this.currentLine);
    }

    @Override
    public void close() {
        this.quitting = true;
        try {
            if (this.socket != null && !this.socket.isClosed()) {
                this.socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

