/*
 * Decompiled with CFR 0.152.
 */
package com.icegreen.greenmail.util;

import com.icegreen.greenmail.server.AbstractServer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.mail.FetchProfile;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Store;
import javax.mail.UIDFolder;

public class Retriever
implements AutoCloseable {
    private AbstractServer server;
    private Store store;

    public Retriever(AbstractServer server) {
        if (null == server) {
            throw new IllegalArgumentException("Expected non null server argument");
        }
        if (!server.getProtocol().startsWith("imap") && !server.getProtocol().startsWith("pop3")) {
            throw new IllegalArgumentException("Requires a pop3 or imap server but got " + server.getProtocol());
        }
        this.server = server;
    }

    public Message[] getMessages(String account) {
        return this.getMessages(account, account);
    }

    public Message[] getMessages(String account, String password) {
        try {
            this.store = this.server.createStore();
            this.store.connect(this.server.getBindTo(), this.server.getPort(), account, password);
            Folder rootFolder = this.store.getFolder("INBOX");
            List<Message> messages = this.getMessages(rootFolder);
            FetchProfile fp = new FetchProfile();
            fp.add((FetchProfile.Item)UIDFolder.FetchProfileItem.UID);
            rootFolder.fetch(rootFolder.getMessages(), fp);
            return messages.toArray(new Message[messages.size()]);
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void logout() {
        this.close();
    }

    @Override
    public void close() {
        try {
            this.store.close();
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
    }

    private List<Message> getMessages(Folder folder) throws MessagingException {
        ArrayList<Message> ret = new ArrayList<Message>();
        if ((folder.getType() & 1) != 0) {
            if (!folder.isOpen()) {
                folder.open(1);
            }
            Message[] messages = folder.getMessages();
            Collections.addAll(ret, messages);
        }
        if ((folder.getType() & 2) != 0) {
            Folder[] f;
            for (Folder aF : f = folder.list()) {
                ret.addAll(this.getMessages(aF));
            }
        }
        return ret;
    }
}

