/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core;

import io.ballerina.architecturemodelgenerator.core.diagnostics.ArchitectureModelDiagnostic;
import io.ballerina.architecturemodelgenerator.core.model.entity.Entity;
import io.ballerina.architecturemodelgenerator.core.model.functionentrypoint.FunctionEntryPoint;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.architecturemodelgenerator.core.model.service.Service;
import java.util.List;
import java.util.Map;

public class ArchitectureModel {
    private final String modelVersion;
    private final String id;
    private final String orgName;
    private final String version;
    private final boolean hasCompilationErrors;
    private final List<ArchitectureModelDiagnostic> diagnostics;
    private final Map<String, Service> services;
    private final Map<String, Entity> entities;
    private final FunctionEntryPoint functionEntryPoint;
    private final List<Connection> connections;

    public ArchitectureModel(String modelVersion, String id, String orgName, String version, List<ArchitectureModelDiagnostic> diagnostics, Map<String, Service> services, Map<String, Entity> entities, FunctionEntryPoint functionEntryPoint, boolean hasCompilationErrors, List<Connection> connections) {
        this.modelVersion = modelVersion;
        this.id = id;
        this.orgName = orgName;
        this.version = version;
        this.diagnostics = diagnostics;
        this.services = services;
        this.entities = entities;
        this.functionEntryPoint = functionEntryPoint;
        this.hasCompilationErrors = hasCompilationErrors;
        this.connections = connections;
    }

    public String getModelVersion() {
        return this.modelVersion;
    }

    public String getId() {
        return String.format("%s/%s:%s", this.orgName, this.id, this.version);
    }

    public String getOrgName() {
        return this.orgName;
    }

    public String getVersion() {
        return this.version;
    }

    public List<ArchitectureModelDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public Map<String, Entity> getEntities() {
        return this.entities;
    }

    public FunctionEntryPoint getFunctionEntryPoint() {
        return this.functionEntryPoint;
    }

    public boolean hasCompilationErrors() {
        return this.hasCompilationErrors;
    }

    public List<Connection> getConnections() {
        return this.connections;
    }
}

