/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.diagnostics;

import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticNode;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public class DiagnosticMessage {
    private final String code;
    private final String description;
    private final DiagnosticSeverity severity;

    private DiagnosticMessage(String code, String description, DiagnosticSeverity severity) {
        this.code = code;
        this.description = description;
        this.severity = severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }

    public static DiagnosticMessage ballerinaProjectNotFound(String projectPath) {
        return new DiagnosticMessage("001", String.format("Ballerina project not found in the path : %s", projectPath), DiagnosticSeverity.ERROR);
    }

    public static DiagnosticMessage failedToResolveBallerinaPackage(String projectPath, String message, String stacktrace) {
        return new DiagnosticMessage("002", String.format("Unexpected error occurred while resolving Ballerina package for the path: %s. %nMessage : %s %nStackTrace : %s", projectPath, message, stacktrace), DiagnosticSeverity.ERROR);
    }

    public static DiagnosticMessage failedToGenerate(DiagnosticNode diagnosticNode, String message) {
        return new DiagnosticMessage("003", String.format("Unexpected error occurred while generating " + diagnosticNode.toString() + ". Message : %s", message), DiagnosticSeverity.ERROR);
    }
}

