/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import java.nio.file.Path;

public abstract class ModelGenerator {
    private final PackageCompilation packageCompilation;
    private final SemanticModel semanticModel;
    private final Module module;
    private final Path moduleRootPath;

    public ModelGenerator(PackageCompilation packageCompilation, Module module) {
        this.packageCompilation = packageCompilation;
        this.semanticModel = packageCompilation.getSemanticModel(module.moduleId());
        this.module = module;
        Path moduleRootPath = module.project().sourceRoot().toAbsolutePath();
        if (module.moduleName().moduleNamePart() != null) {
            moduleRootPath = moduleRootPath.resolve("modules").resolve(module.moduleName().moduleNamePart());
        }
        this.moduleRootPath = moduleRootPath;
    }

    public PackageCompilation getPackageCompilation() {
        return this.packageCompilation;
    }

    public SemanticModel getSemanticModel() {
        return this.semanticModel;
    }

    public Module getModule() {
        return this.module;
    }

    public Path getModuleRootPath() {
        return this.moduleRootPath;
    }
}

